/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects.subobjects;

import es.tid.rsvp.objects.subobjects.EROSubobject;
import java.net.Inet6Address;
import java.net.UnknownHostException;

public class IPv6prefixEROSubobject
extends EROSubobject {
    public Inet6Address ipv6address;
    public int prefix;

    public IPv6prefixEROSubobject() {
        this.setType(2);
    }

    public IPv6prefixEROSubobject(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.erosolength = 20;
        this.subobject_bytes = new byte[this.erosolength];
        this.encodeSoHeader();
        System.arraycopy(this.ipv6address.getAddress(), 0, this.subobject_bytes, 2, 16);
        this.subobject_bytes[18] = (byte)this.prefix;
        this.subobject_bytes[19] = 0;
    }

    @Override
    public void decode() {
        byte[] ipadd = new byte[16];
        System.arraycopy(this.subobject_bytes, 2, ipadd, 0, 16);
        try {
            this.ipv6address = (Inet6Address)Inet6Address.getByAddress(ipadd);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.prefix = this.subobject_bytes[18];
    }

    public Inet6Address getIpv6address() {
        return this.ipv6address;
    }

    public void setIpv6address(Inet6Address ipv6address) {
        this.ipv6address = ipv6address;
    }

    public int getPrefix() {
        return this.prefix;
    }

    public void setPrefix(int prefix) {
        this.prefix = prefix;
    }

    public String toString() {
        return "IPv6prefixEROSubobject [ipv6address=" + String.valueOf(this.ipv6address) + ", prefix=" + this.prefix + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.ipv6address == null ? 0 : this.ipv6address.hashCode());
        result = 31 * result + this.prefix;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IPv6prefixEROSubobject other = (IPv6prefixEROSubobject)obj;
        if (this.ipv6address == null ? other.ipv6address != null : !this.ipv6address.equals(other.ipv6address)) {
            return false;
        }
        return this.prefix == other.prefix;
    }
}

