/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects.subobjects;

import es.tid.rsvp.objects.subobjects.RROSubobject;
import java.net.Inet6Address;
import java.net.UnknownHostException;

public class IPv6AddressRROSubobject
extends RROSubobject {
    public Inet6Address ipv6address;
    public int prefix;

    public IPv6AddressRROSubobject() {
        this.setType(2);
    }

    public IPv6AddressRROSubobject(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.rrosolength = 20;
        this.subobject_bytes = new byte[this.rrosolength];
        this.encodeSoHeader();
        System.arraycopy(this.ipv6address.getAddress(), 0, this.subobject_bytes, 2, 16);
        this.subobject_bytes[18] = (byte)this.prefix;
        this.subobject_bytes[19] = 0;
    }

    @Override
    public void decode() {
        byte[] ipadd = new byte[16];
        System.arraycopy(this.subobject_bytes, 2, ipadd, 0, 16);
        try {
            this.ipv6address = (Inet6Address)Inet6Address.getByAddress(ipadd);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.prefix = this.subobject_bytes[18];
    }

    public Inet6Address getIpv6address() {
        return this.ipv6address;
    }

    public void setIpv6address(Inet6Address ipv6address) {
        this.ipv6address = ipv6address;
    }

    public int getPrefix() {
        return this.prefix;
    }

    public void setPrefix(int prefix) {
        this.prefix = prefix;
    }
}

