/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects.subobjects;

import es.tid.rsvp.objects.subobjects.RROSubobject;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public class IPv4AddressRROSubobject
extends RROSubobject {
    public Inet4Address ipv4address;
    public int prefix;

    public IPv4AddressRROSubobject() {
        this.setType(1);
        this.setRrosolength(8);
    }

    public IPv4AddressRROSubobject(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.rrosolength = 8;
        this.subobject_bytes = new byte[this.rrosolength];
        this.encodeSoHeader();
        System.arraycopy(this.ipv4address.getAddress(), 0, this.subobject_bytes, 2, 4);
        this.subobject_bytes[6] = (byte)this.prefix;
        this.subobject_bytes[7] = 0;
    }

    @Override
    public void decode() {
        byte[] ipadd = new byte[4];
        System.arraycopy(this.subobject_bytes, 2, ipadd, 0, 4);
        try {
            this.ipv4address = (Inet4Address)Inet4Address.getByAddress(ipadd);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.prefix = this.subobject_bytes[6];
    }

    public Inet4Address getIpv4address() {
        return this.ipv4address;
    }

    public void setIpv4address(Inet4Address ipv4address) {
        this.ipv4address = ipv4address;
    }

    public int getPrefix() {
        return this.prefix;
    }

    public void setPrefix(int prefix) {
        this.prefix = prefix;
    }

    public String toString() {
        return this.ipv4address.getHostAddress();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ipv4address == null ? 0 : this.ipv4address.hashCode());
        result = 31 * result + this.prefix;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IPv4AddressRROSubobject other = (IPv4AddressRROSubobject)obj;
        if (this.ipv4address == null ? other.ipv4address != null : !this.ipv4address.equals(other.ipv4address)) {
            return false;
        }
        return this.prefix == other.prefix;
    }
}

