/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects.subobjects;

import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.subtlvs.SubTLV;
import es.tid.rsvp.objects.subobjects.subtlvs.SubTransponderTLV;
import java.util.LinkedList;

public class ETCEROSubobject
extends EROSubobject {
    private LinkedList<SubTransponderTLV> subTransponderList;

    public ETCEROSubobject() {
        this.setType(10);
        this.subTransponderList = new LinkedList();
    }

    public ETCEROSubobject(byte[] bytes, int offset) {
        super(bytes, offset);
        this.subTransponderList = new LinkedList();
        this.decode();
    }

    @Override
    public void encode() {
        int len = 4;
        if (this.subTransponderList != null) {
            int k = 0;
            while (k < this.subTransponderList.size()) {
                this.subTransponderList.get(k).encode();
                len += this.subTransponderList.get(k).getTotalTLVLength();
                ++k;
            }
        }
        this.erosolength = len;
        this.subobject_bytes = new byte[this.erosolength];
        this.encodeSoHeader();
        int pos = 4;
        if (this.subTransponderList != null) {
            int k = 0;
            while (k < this.subTransponderList.size()) {
                System.arraycopy(this.subTransponderList.get(k).getTlv_bytes(), 0, this.subobject_bytes, pos, this.subTransponderList.get(k).getTotalTLVLength());
                pos += this.subTransponderList.get(k).getTotalTLVLength();
                ++k;
            }
        }
    }

    @Override
    public void decode() {
        boolean fin = false;
        int offset = 4;
        while (!fin) {
            int subtlvType = SubTLV.getType(this.subobject_bytes, offset);
            int subtlvLength = SubTLV.getTotalTLVLength(this.subobject_bytes, offset);
            switch (subtlvType) {
                case 1: {
                    System.out.println("ERO_SUBTLV_SUBTRANSPONDER FOUND");
                    SubTransponderTLV a = new SubTransponderTLV(this.subobject_bytes, offset);
                    this.subTransponderList.add(a);
                    break;
                }
                default: {
                    System.out.println("xx SubTransponderTLV Unknown ");
                }
            }
            if ((offset += subtlvLength) >= this.erosolength) {
                fin = true;
                continue;
            }
            System.out.println("sigo leyendo SubTransponderTLV ");
        }
    }

    public LinkedList<SubTransponderTLV> getSubTransponderList() {
        return this.subTransponderList;
    }

    public void setSubTransponderList(LinkedList<SubTransponderTLV> subTransponderList) {
        this.subTransponderList = subTransponderList;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(this.subTransponderList.size() * 100);
        sb.append("<ETC: ");
        int i = 0;
        while (i < this.subTransponderList.size()) {
            sb.append(this.subTransponderList.get(i).toString());
            sb.append(" ");
            ++i;
        }
        sb.append(">");
        return sb.toString();
    }
}

