/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects.gmpls;

import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.objects.LabelRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralizedLabelRequest
extends LabelRequest {
    private int lspEncodingType;
    private int switchingType;
    private int gpid;
    private static final Logger log = LoggerFactory.getLogger((String)"ROADM");

    public GeneralizedLabelRequest(int lspEncodingType, int switchingType, int gpid) {
        this.classNum = 19;
        this.cType = 4;
        this.lspEncodingType = lspEncodingType;
        this.switchingType = switchingType;
        this.gpid = gpid;
        this.length = 8;
        log.debug("Generalized Label Request Object Created");
    }

    public GeneralizedLabelRequest(byte[] bytes, int offset) {
        this.decodeHeader(bytes, offset);
        this.bytes = new byte[this.getLength()];
        log.debug("Generalized Label Request Object Created");
    }

    @Override
    public void encode() throws RSVPProtocolViolationException {
        this.bytes = new byte[this.length];
        this.encodeHeader();
        int currentIndex = 4;
        this.bytes[currentIndex] = (byte)(this.lspEncodingType & 0xFF);
        this.bytes[currentIndex + 1] = (byte)(this.switchingType & 0xFF);
        this.bytes[currentIndex + 2] = (byte)(this.gpid >> 8 & 0xFF);
        this.bytes[currentIndex + 3] = (byte)(this.gpid & 0xFF);
    }

    public void decode(byte[] bytes, int offset) throws RSVPProtocolViolationException {
    }
}

