/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects.gmpls;

import es.tid.protocol.commons.ByteHandler;
import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.objects.Label;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralizedLabel
extends Label {
    private long label;
    private static final Logger log = LoggerFactory.getLogger((String)"ROADM");

    public GeneralizedLabel() {
        this.classNum = 16;
        this.cType = 2;
    }

    public GeneralizedLabel(long label) {
        this.classNum = 16;
        this.cType = 2;
        this.label = label;
        log.debug("Generalized Label Request Object Created");
    }

    public GeneralizedLabel(byte[] bytes, int offset) throws RSVPProtocolViolationException {
        this.decode();
        log.debug("Generalized Label Request Object Created");
    }

    @Override
    public void encode() throws RSVPProtocolViolationException {
        this.length = 8;
        this.bytes = new byte[this.length];
        this.encodeHeader();
        this.bytes[4] = (byte)(this.label >> 24 & 0xFFL);
        this.bytes[5] = (byte)(this.label >> 16 & 0xFFL);
        this.bytes[6] = (byte)(this.label >> 8 & 0xFFL);
        this.bytes[7] = (byte)(this.label & 0xFFL);
    }

    @Override
    public void decode() throws RSVPProtocolViolationException {
        int offset = 4;
        this.label = ByteHandler.decode4bytesLong(this.bytes, offset);
    }

    @Override
    public long getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(long label) {
        this.label = label;
    }
}

