/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects;

import es.tid.protocol.commons.ByteHandler;
import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.objects.Label;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SuggestedLabel
extends Label {
    private static final Logger log = LoggerFactory.getLogger((String)"ROADM");

    public SuggestedLabel() {
        this.classNum = 129;
        this.cType = 2;
    }

    public SuggestedLabel(int label) {
        this.classNum = 129;
        this.cType = 2;
        this.label = label;
        log.debug("Label Object Created");
    }

    public SuggestedLabel(byte[] bytes, int offset) throws RSVPProtocolViolationException {
        super(bytes, offset);
        this.decode();
        log.debug("Label Object Created");
    }

    @Override
    public void encode() throws RSVPProtocolViolationException {
        this.length = 8;
        this.bytes = new byte[this.length];
        this.encodeHeader();
        int currentIndex = 4;
        this.bytes[currentIndex] = (byte)(this.label >> 24 & 0xFFL);
        this.bytes[currentIndex + 1] = (byte)(this.label >> 16 & 0xFFL);
        this.bytes[currentIndex + 2] = (byte)(this.label >> 8 & 0xFFL);
        this.bytes[currentIndex + 3] = (byte)(this.label & 0xFFL);
    }

    @Override
    public void decode() throws RSVPProtocolViolationException {
        int offset = 4;
        super.setLabel(ByteHandler.decode4bytesLong(this.bytes, offset));
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        return this.getClass() == obj.getClass();
    }
}

