/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects;

import es.tid.protocol.commons.ByteHandler;
import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.objects.Session;
import java.net.Inet6Address;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionLSPTunnelIPv6
extends Session {
    protected Inet6Address egressNodeAddress;
    protected int tunnelId;
    protected Inet6Address extendedTunnelId;
    private static final Logger log = LoggerFactory.getLogger((String)"ROADM");

    public SessionLSPTunnelIPv6() {
        this.classNum = 1;
        this.cType = 8;
        log.debug("Session LSP Tunnel IPv6 Object Created");
    }

    public SessionLSPTunnelIPv6(Inet6Address egressNodeAddress, int tunnelId, Inet6Address extendedTunnelId) {
        this.classNum = 1;
        this.cType = 8;
        this.egressNodeAddress = egressNodeAddress;
        this.tunnelId = tunnelId;
        this.extendedTunnelId = extendedTunnelId;
        log.debug("Session LSP Tunnel IPv6 Object Created");
    }

    public SessionLSPTunnelIPv6(byte[] bytes, int offset) throws RSVPProtocolViolationException {
        super(bytes, offset);
        this.decode();
        log.debug("Session LSP Tunnel IPv6 Object Created");
    }

    @Override
    public void encode() {
        this.length = 40;
        this.bytes = new byte[this.length];
        this.encodeHeader();
        byte[] addr = this.egressNodeAddress.getAddress();
        int currentIndex = 4;
        System.arraycopy(addr, 0, this.getBytes(), currentIndex, addr.length);
        this.bytes[currentIndex += addr.length] = 0;
        this.bytes[currentIndex + 1] = 0;
        this.bytes[currentIndex + 2] = (byte)(this.tunnelId >> 8 & 0xFF);
        this.bytes[currentIndex + 3] = (byte)(this.tunnelId & 0xFF);
        addr = this.extendedTunnelId.getAddress();
        System.arraycopy(addr, 0, this.getBytes(), currentIndex += 4, addr.length);
    }

    public void decode() throws RSVPProtocolViolationException {
        try {
            int offset = 0;
            byte[] receivedAddress = new byte[16];
            System.arraycopy(this.bytes, offset + 4, receivedAddress, 0, 16);
            this.egressNodeAddress = (Inet6Address)Inet6Address.getByAddress(receivedAddress);
            this.tunnelId = ByteHandler.decode2bytesInteger(this.bytes, (offset += 20) + 2);
            System.arraycopy(this.bytes, offset += 4, receivedAddress, 0, 16);
            this.extendedTunnelId = (Inet6Address)Inet6Address.getByAddress(receivedAddress);
        }
        catch (Exception e) {
            throw new RSVPProtocolViolationException();
        }
    }

    public Inet6Address getEgressNodeAddress() {
        return this.egressNodeAddress;
    }

    public void setEgressNodeAddress(Inet6Address egressNodeAddress) {
        this.egressNodeAddress = egressNodeAddress;
    }

    public int getTunnelId() {
        return this.tunnelId;
    }

    public void setTunnelId(int tunnelId) {
        this.tunnelId = tunnelId;
    }

    public Inet6Address getExtendedTunnelId() {
        return this.extendedTunnelId;
    }

    public void setExtendedTunnelId(Inet6Address extendedTunnelId) {
        this.extendedTunnelId = extendedTunnelId;
    }
}

