/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects;

import es.tid.protocol.commons.ByteHandler;
import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.objects.SessionAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionAttributeWResourceAffinities
extends SessionAttribute {
    private long excludeAny;
    private long includeAny;
    private long includeAll;
    private int setupPriority;
    private int holdingPriority;
    private int flags;
    private int nameLength;
    private String sessionName;
    private static final Logger log = LoggerFactory.getLogger((String)"ROADM");

    public SessionAttributeWResourceAffinities() {
        this.cType = 1;
    }

    public SessionAttributeWResourceAffinities(int excludeAny, int includeAny, int includeAll, int setupPriority, int holdingPriority, int flags, String sessionName) {
        this.classNum = 207;
        this.cType = 1;
        this.excludeAny = excludeAny;
        this.includeAny = includeAny;
        this.includeAll = includeAll;
        this.setupPriority = setupPriority;
        this.holdingPriority = holdingPriority;
        this.flags = flags;
        this.sessionName = sessionName;
        log.debug("Session Attribute With Resource Affinities Object Created");
    }

    public SessionAttributeWResourceAffinities(byte[] bytes, int offset) throws RSVPProtocolViolationException {
        super(bytes, offset);
        this.decode();
        log.debug("Session Attribute With Resource Affinities Object Created");
    }

    @Override
    public void encode() throws RSVPProtocolViolationException {
        log.debug("Starting Session Attribute With Resource Affinities encode");
        this.length = 20;
        double sessionNameLength = this.sessionName.getBytes().length;
        this.nameLength = (int)sessionNameLength;
        int sessionName4BytesAlignLength = (int)Math.ceil(sessionNameLength / 4.0) * 4;
        this.length += sessionName4BytesAlignLength;
        this.bytes = new byte[this.getLength()];
        this.encodeHeader();
        int currentIndex = 4;
        this.bytes[currentIndex] = (byte)(this.excludeAny >> 24 & 0xFFL);
        this.bytes[currentIndex + 1] = (byte)(this.excludeAny >> 16 & 0xFFL);
        this.bytes[currentIndex + 2] = (byte)(this.excludeAny >> 8 & 0xFFL);
        this.bytes[currentIndex + 3] = (byte)(this.excludeAny & 0xFFL);
        this.bytes[currentIndex += 4] = (byte)(this.includeAny >> 24 & 0xFFL);
        this.bytes[currentIndex + 1] = (byte)(this.includeAny >> 16 & 0xFFL);
        this.bytes[currentIndex + 2] = (byte)(this.includeAny >> 8 & 0xFFL);
        this.bytes[currentIndex + 3] = (byte)(this.includeAny & 0xFFL);
        this.bytes[currentIndex += 4] = (byte)(this.includeAll >> 24 & 0xFFL);
        this.bytes[currentIndex + 1] = (byte)(this.includeAll >> 16 & 0xFFL);
        this.bytes[currentIndex + 2] = (byte)(this.includeAll >> 8 & 0xFFL);
        this.bytes[currentIndex + 3] = (byte)(this.includeAll & 0xFFL);
        this.bytes[currentIndex += 4] = (byte)this.setupPriority;
        this.bytes[currentIndex + 1] = (byte)this.holdingPriority;
        this.bytes[currentIndex + 2] = (byte)this.flags;
        this.bytes[currentIndex + 3] = (byte)this.nameLength;
        System.arraycopy(this.sessionName.getBytes(), 0, this.bytes, currentIndex += 4, this.sessionName.getBytes().length);
        byte[] padding = new byte[this.length - (currentIndex += this.nameLength)];
        System.arraycopy(padding, 0, this.bytes, currentIndex, this.length - currentIndex);
        log.debug("Encoding Session Attribute With Resource Affinities accomplished");
    }

    public void decode() throws RSVPProtocolViolationException {
        int offset = 0;
        log.debug("Starting Session Attribute With Resource Affinities decode");
        int currentIndex = offset + 4;
        this.excludeAny = ByteHandler.decode4bytesLong(this.bytes, currentIndex);
        this.includeAny = ByteHandler.decode4bytesLong(this.bytes, currentIndex += 4);
        this.includeAll = ByteHandler.decode4bytesLong(this.bytes, currentIndex += 4);
        this.setupPriority = this.bytes[currentIndex += 4] & 0xFF;
        this.holdingPriority = this.bytes[currentIndex + 1] & 0xFF;
        this.flags = this.bytes[currentIndex + 2] & 0xFF;
        this.nameLength = this.bytes[currentIndex + 3] & 0xFF;
        byte[] sessionNameBytes = new byte[this.nameLength];
        System.arraycopy(this.bytes, currentIndex += 4, sessionNameBytes, 0, this.nameLength);
        this.sessionName = new String(sessionNameBytes);
        log.debug("Decoding Session Attribute With Resource Affinities accomplished");
    }

    public int getSetupPriority() {
        return this.setupPriority;
    }

    public void setSetupPriority(int setupPriority) {
        this.setupPriority = setupPriority;
    }

    public int getHoldingPriority() {
        return this.holdingPriority;
    }

    public void setHoldingPriority(int holdingPriority) {
        this.holdingPriority = holdingPriority;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getNameLength() {
        return this.nameLength;
    }

    public void setNameLength(int nameLength) {
        this.nameLength = nameLength;
    }

    public String getSessionName() {
        return this.sessionName;
    }

    public void setSessionName(String sessionName) {
        this.sessionName = sessionName;
    }

    public long getExcludeAny() {
        return this.excludeAny;
    }

    public void setExcludeAny(long excludeAny) {
        this.excludeAny = excludeAny;
    }

    public long getIncludeAny() {
        return this.includeAny;
    }

    public void setIncludeAny(long includeAny) {
        this.includeAny = includeAny;
    }

    public long getIncludeAll() {
        return this.includeAll;
    }

    public void setIncludeAll(long includeAll) {
        this.includeAll = includeAll;
    }
}

