/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects;

import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.objects.Scope;
import java.net.Inet6Address;
import java.net.UnknownHostException;
import java.util.LinkedList;

public class ScopeIPv6
extends Scope {
    protected LinkedList<Inet6Address> sourceIpAddresses;

    public ScopeIPv6() {
        this.classNum = 7;
        this.cType = 2;
        this.sourceIpAddresses = new LinkedList();
    }

    public ScopeIPv6(byte[] bytes, int offset) throws RSVPProtocolViolationException {
        super(bytes, offset);
        this.decode();
    }

    public void addSourceIpAddress(Inet6Address addr) {
        this.sourceIpAddresses.add(addr);
    }

    @Override
    public void encode() {
        int size = this.sourceIpAddresses.size();
        this.length = 4 + size * 16;
        this.bytes = new byte[this.length];
        this.encodeHeader();
        int currentIndex = 4;
        int i = 0;
        while (i < size) {
            byte[] addr = this.sourceIpAddresses.get(i).getAddress();
            System.arraycopy(addr, 0, this.getBytes(), currentIndex, addr.length);
            currentIndex += 16;
            ++i;
        }
    }

    public void decode() {
        this.sourceIpAddresses = new LinkedList();
        int offset = 0;
        this.length = this.bytes[offset] | this.bytes[offset + 1];
        int headerSize = 4;
        int unprocessedBytes = this.length - headerSize;
        int currentIndex = offset + headerSize;
        while (unprocessedBytes > 0) {
            byte[] readAddress = new byte[16];
            System.arraycopy(this.bytes, currentIndex, readAddress, 0, 16);
            try {
                Inet6Address newAddress = (Inet6Address)Inet6Address.getByAddress(readAddress);
                this.addSourceIpAddress(newAddress);
                currentIndex += 16;
                unprocessedBytes -= 16;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    public LinkedList<Inet6Address> getSourceIpAddresses() {
        return this.sourceIpAddresses;
    }

    public void setSourceIpAddresses(LinkedList<Inet6Address> sourceIpAddresses) {
        this.sourceIpAddresses = sourceIpAddresses;
    }
}

