/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects;

import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.objects.Scope;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.LinkedList;

public class ScopeIPv4
extends Scope {
    protected LinkedList<Inet4Address> sourceIpAddresses;

    public ScopeIPv4() {
        this.classNum = 7;
        this.cType = 1;
        this.sourceIpAddresses = new LinkedList();
    }

    public ScopeIPv4(byte[] bytes, int offset) throws RSVPProtocolViolationException {
        super(bytes, offset);
        this.decode();
    }

    public void addSourceIpAddress(Inet4Address addr) {
        this.sourceIpAddresses.add(addr);
    }

    @Override
    public void encode() {
        int size = this.sourceIpAddresses.size();
        this.length = 4 + size * 4;
        this.bytes = new byte[this.length];
        this.encodeHeader();
        int currentIndex = 4;
        int i = 0;
        while (i < size) {
            byte[] addr = this.sourceIpAddresses.get(i).getAddress();
            System.arraycopy(addr, 0, this.getBytes(), currentIndex, addr.length);
            currentIndex += 4;
            ++i;
        }
    }

    public void decode() {
        this.sourceIpAddresses = new LinkedList();
        int offset = 0;
        int headerSize = 4;
        int unprocessedBytes = this.length - headerSize;
        int currentIndex = offset + headerSize;
        while (unprocessedBytes > 0) {
            byte[] readAddress = new byte[4];
            System.arraycopy(this.bytes, currentIndex, readAddress, 0, 4);
            try {
                Inet4Address newAddress = (Inet4Address)Inet4Address.getByAddress(readAddress);
                this.addSourceIpAddress(newAddress);
                currentIndex += 4;
                unprocessedBytes -= 4;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
    }

    public LinkedList<Inet4Address> getSourceIpAddresses() {
        return this.sourceIpAddresses;
    }

    public void setSourceIpAddresses(LinkedList<Inet4Address> sourceIpAddresses) {
        this.sourceIpAddresses = sourceIpAddresses;
    }
}

