/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects;

import es.tid.rsvp.objects.ResvConfirm;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public class ResvConfirmIPv4
extends ResvConfirm {
    protected Inet4Address receiverAddress;

    public ResvConfirmIPv4() {
        this.classNum = 15;
        this.cType = 1;
    }

    public ResvConfirmIPv4(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.length = 8;
        this.bytes = new byte[this.length];
        this.encodeHeader();
        byte[] addr = this.receiverAddress.getAddress();
        System.arraycopy(addr, 0, this.getBytes(), 4, addr.length);
    }

    @Override
    public void decode() {
        int offset = 0;
        byte[] receivedAddress = new byte[4];
        System.arraycopy(this.bytes, offset + 4, receivedAddress, 0, 4);
        try {
            this.receiverAddress = (Inet4Address)Inet4Address.getByAddress(receivedAddress);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
    }

    public Inet4Address getReceiverAddress() {
        return this.receiverAddress;
    }

    public void setReceiverAddress(Inet4Address receiverAddress) {
        this.receiverAddress = receiverAddress;
    }
}

