/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects;

import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.objects.RSVPHop;
import java.net.Inet6Address;
import java.net.UnknownHostException;

public class RSVPHopIPv6
extends RSVPHop {
    protected Inet6Address next_previousHopAddress;
    protected int logicalInterfaceHandle;

    public RSVPHopIPv6() {
        this.classNum = 3;
        this.cType = 2;
        this.logicalInterfaceHandle = 0;
    }

    public RSVPHopIPv6(byte[] bytes, int offset) throws RSVPProtocolViolationException {
        super(bytes, offset);
        this.decode();
    }

    public RSVPHopIPv6(Inet6Address next_previousHopAddress, int logicalInterfaceHandle) {
        this.classNum = 3;
        this.cType = 2;
        this.length = 24;
        this.bytes = new byte[this.length];
        this.next_previousHopAddress = next_previousHopAddress;
        this.logicalInterfaceHandle = logicalInterfaceHandle;
    }

    @Override
    public void encode() {
        this.length = 24;
        this.bytes = new byte[this.length];
        this.encodeHeader();
        byte[] addr = this.next_previousHopAddress.getAddress();
        System.arraycopy(addr, 0, this.getBytes(), 4, addr.length);
        this.bytes[20] = (byte)(this.logicalInterfaceHandle >> 24 & 0xFF);
        this.bytes[21] = (byte)(this.logicalInterfaceHandle >> 16 & 0xFF);
        this.bytes[22] = (byte)(this.logicalInterfaceHandle >> 8 & 0xFF);
        this.bytes[23] = (byte)(this.logicalInterfaceHandle & 0xFF);
    }

    @Override
    public void decode() {
        int offset = 0;
        byte[] receivedAddress = new byte[16];
        System.arraycopy(this.bytes, offset + 4, receivedAddress, 0, 16);
        try {
            this.next_previousHopAddress = (Inet6Address)Inet6Address.getByAddress(receivedAddress);
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        this.logicalInterfaceHandle = this.bytes[offset + 20] | this.bytes[offset + 21] | this.bytes[offset + 22] | this.bytes[offset + 23];
    }

    public Inet6Address getNext_previousHopAddress() {
        return this.next_previousHopAddress;
    }

    public void setNext_previousHopAddress(Inet6Address next_previousHopAddress) {
        this.next_previousHopAddress = next_previousHopAddress;
    }

    public int getLogicalInterfaceHandle() {
        return this.logicalInterfaceHandle;
    }

    public void setLogicalInterfaceHandle(int logicalInterfaceHandle) {
        this.logicalInterfaceHandle = logicalInterfaceHandle;
    }
}

