/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects;

import es.tid.protocol.commons.ByteHandler;
import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.objects.RSVPObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Label
extends RSVPObject {
    protected long label;
    private static final Logger log = LoggerFactory.getLogger((String)"ROADM");

    public Label(int label) {
        this.classNum = 16;
        this.cType = 1;
        this.length = 4;
        this.label = label;
        log.debug("Label Object Created");
    }

    public Label() {
        this.classNum = 16;
        this.cType = 1;
    }

    public Label(byte[] bytes, int offset) throws RSVPProtocolViolationException {
        super(bytes, offset);
        this.decode();
        log.debug("Label Object Created");
    }

    @Override
    public void encode() throws RSVPProtocolViolationException {
        this.length = 4;
        this.length += 4;
        this.bytes = new byte[this.length];
        this.encodeHeader();
        int currentIndex = 4;
        this.bytes[currentIndex] = (byte)(this.label >> 24 & 0xFFL);
        this.bytes[currentIndex + 1] = (byte)(this.label >> 16 & 0xFFL);
        this.bytes[currentIndex + 2] = (byte)(this.label >> 8 & 0xFFL);
        this.bytes[currentIndex + 3] = (byte)(this.label & 0xFFL);
    }

    public void decode() throws RSVPProtocolViolationException {
        int offset = 4;
        this.label = ByteHandler.decode4bytesLong(this.bytes, offset);
    }

    public long getLabel() {
        return this.label;
    }

    public void setLabel(long label) {
        this.label = label;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.label ^ this.label >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Label other = (Label)obj;
        return this.label == other.label;
    }
}

