/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects;

import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.objects.SenderTSpec;

public class IntservSenderTSpec
extends SenderTSpec {
    private int formatVersionNumber;
    private int overallLength;
    private int serviceHeader;
    private int lengthOfService;
    private int parameterID;
    private int parameter127Flags;
    private int parameter127length;
    private float tokenBucketRate;
    private float tokenBucketSize;
    private float peakDataRate;
    private long minimumPoliciedUnit;
    private long maximumPacketSize;

    public IntservSenderTSpec() {
        this.cType = 2;
    }

    public IntservSenderTSpec(byte[] bytes, int offset) throws RSVPProtocolViolationException {
        super(bytes, offset);
        this.decode();
    }

    public IntservSenderTSpec(float tokenBucketRate, float tokenBucketSize, float peakDataRate, long minimumPoliciedUnit, long maximumPacketSize) {
        this.formatVersionNumber = 0;
        this.overallLength = 7;
        this.serviceHeader = 1;
        this.lengthOfService = 6;
        this.parameterID = 127;
        this.parameter127Flags = 0;
        this.parameter127length = 5;
        this.tokenBucketRate = tokenBucketRate;
        this.tokenBucketSize = tokenBucketSize;
        this.peakDataRate = peakDataRate;
        this.minimumPoliciedUnit = minimumPoliciedUnit;
        this.maximumPacketSize = maximumPacketSize;
        this.classNum = 12;
        this.cType = 2;
    }

    @Override
    public void encode() {
        this.length = 36;
        this.bytes = new byte[this.length];
        this.encodeHeader();
        int offset = 4;
        this.bytes[offset] = (byte)(this.formatVersionNumber >> 4 & 0xF0);
        this.bytes[offset + 1] = 0;
        this.bytes[offset + 2] = (byte)(this.overallLength >> 8 & 0xFF);
        this.bytes[offset + 3] = (byte)(this.overallLength & 0xFF);
        this.bytes[offset += 4] = (byte)(this.serviceHeader & 0xFF);
        this.bytes[offset + 1] = 0;
        this.bytes[offset + 2] = (byte)(this.lengthOfService >> 8 & 0xFF);
        this.bytes[offset + 3] = (byte)(this.lengthOfService & 0xFF);
        this.bytes[offset += 4] = (byte)(this.parameterID & 0xFF);
        this.bytes[offset + 1] = (byte)(this.parameter127Flags & 0xFF);
        this.bytes[offset + 2] = (byte)(this.parameter127length >> 8 & 0xFF);
        this.bytes[offset + 3] = (byte)(this.parameter127length & 0xFF);
        int tbr = Float.floatToIntBits(this.tokenBucketRate);
        this.bytes[offset += 4] = (byte)(tbr >>> 24);
        this.bytes[offset + 1] = (byte)(tbr >> 16 & 0xFF);
        this.bytes[offset + 2] = (byte)(tbr >> 8 & 0xFF);
        this.bytes[offset + 3] = (byte)(tbr & 0xFF);
        int tbs = Float.floatToIntBits(this.tokenBucketSize);
        this.bytes[offset += 4] = (byte)(tbs >>> 24);
        this.bytes[offset + 1] = (byte)(tbs >> 16 & 0xFF);
        this.bytes[offset + 2] = (byte)(tbs >> 8 & 0xFF);
        this.bytes[offset + 3] = (byte)(tbs & 0xFF);
        int pdr = Float.floatToIntBits(this.peakDataRate);
        this.bytes[offset += 4] = (byte)(pdr >>> 24);
        this.bytes[offset + 1] = (byte)(pdr >> 16 & 0xFF);
        this.bytes[offset + 2] = (byte)(pdr >> 8 & 0xFF);
        this.bytes[offset + 3] = (byte)(pdr & 0xFF);
        this.bytes[offset += 4] = (byte)(this.minimumPoliciedUnit >>> 24);
        this.bytes[offset + 1] = (byte)(this.minimumPoliciedUnit >> 16 & 0xFFL);
        this.bytes[offset + 2] = (byte)(this.minimumPoliciedUnit >> 8 & 0xFFL);
        this.bytes[offset + 3] = (byte)(this.minimumPoliciedUnit & 0xFFL);
        this.bytes[offset += 4] = (byte)(this.maximumPacketSize >>> 24);
        this.bytes[offset + 1] = (byte)(this.maximumPacketSize >> 16 & 0xFFL);
        this.bytes[offset + 2] = (byte)(this.maximumPacketSize >> 8 & 0xFFL);
        this.bytes[offset + 3] = (byte)(this.maximumPacketSize & 0xFFL);
    }

    public void decode() {
    }

    public int getFormatVersionNumber() {
        return this.formatVersionNumber;
    }

    public void setFormatVersionNumber(int formatVersionNumber) {
        this.formatVersionNumber = formatVersionNumber;
    }

    public int getOverallLength() {
        return this.overallLength;
    }

    public void setOverallLength(int overallLength) {
        this.overallLength = overallLength;
    }

    public int getServiceHeader() {
        return this.serviceHeader;
    }

    public void setServiceHeader(int serviceHeader) {
        this.serviceHeader = serviceHeader;
    }

    public int getLengthOfService() {
        return this.lengthOfService;
    }

    public void setLengthOfService(int lengthOfService) {
        this.lengthOfService = lengthOfService;
    }

    public int getParameterID() {
        return this.parameterID;
    }

    public void setParameterID(int parameterID) {
        this.parameterID = parameterID;
    }

    public int getParameter127Flags() {
        return this.parameter127Flags;
    }

    public void setParameter127Flags(int parameter127Flags) {
        this.parameter127Flags = parameter127Flags;
    }

    public int getParameter127length() {
        return this.parameter127length;
    }

    public void setParameter127length(int parameter127length) {
        this.parameter127length = parameter127length;
    }

    public float getTokenBucketRate() {
        return this.tokenBucketRate;
    }

    public void setTokenBucketRate(float tokenBucketRate) {
        this.tokenBucketRate = tokenBucketRate;
    }

    public float getTokenBucketSize() {
        return this.tokenBucketSize;
    }

    public void setTokenBucketSize(float tokenBucketSize) {
        this.tokenBucketSize = tokenBucketSize;
    }

    public float getPeakDataRate() {
        return this.peakDataRate;
    }

    public void setPeakDataRate(float peakDataRate) {
        this.peakDataRate = peakDataRate;
    }

    public long getMinimumPoliciedUnit() {
        return this.minimumPoliciedUnit;
    }

    public void setMinimumPoliciedUnit(long minimumPoliciedUnit) {
        this.minimumPoliciedUnit = minimumPoliciedUnit;
    }

    public long getMaximumPacketSize() {
        return this.maximumPacketSize;
    }

    public void setMaximumPacketSize(long maximumPacketSize) {
        this.maximumPacketSize = maximumPacketSize;
    }
}

