/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects;

import es.tid.protocol.commons.ByteHandler;
import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.objects.Hello;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HelloRequest
extends Hello {
    private long srcInstance;
    private long dstInstance;
    private static final Logger log = LoggerFactory.getLogger((String)"ROADM");

    public HelloRequest() {
        this.classNum = 22;
        this.cType = 1;
    }

    public HelloRequest(long srcInstance, long dstInstance) {
        this.classNum = 22;
        this.cType = 1;
        this.srcInstance = srcInstance;
        this.dstInstance = dstInstance;
        this.length = 12;
        log.debug("Hello Request Object Created");
    }

    public HelloRequest(byte[] bytes, int offset) throws RSVPProtocolViolationException {
        super(bytes, offset);
        this.decodeHeader(bytes, offset);
        this.decode(bytes, offset);
        log.debug("Hello Request Object Created");
    }

    @Override
    public void encode() throws RSVPProtocolViolationException {
        log.debug("Starting Hello Request encode");
        this.length = 12;
        this.bytes = new byte[this.getLength()];
        this.encodeHeader();
        int currentIndex = 4;
        this.bytes[currentIndex] = (byte)(this.srcInstance >> 24 & 0xFFL);
        this.bytes[currentIndex + 1] = (byte)(this.srcInstance >> 16 & 0xFFL);
        this.bytes[currentIndex + 2] = (byte)(this.srcInstance >> 8 & 0xFFL);
        this.bytes[currentIndex + 3] = (byte)(this.srcInstance & 0xFFL);
        this.bytes[currentIndex += 4] = (byte)(this.dstInstance >> 24 & 0xFFL);
        this.bytes[currentIndex + 1] = (byte)(this.dstInstance >> 16 & 0xFFL);
        this.bytes[currentIndex + 2] = (byte)(this.dstInstance >> 8 & 0xFFL);
        this.bytes[currentIndex + 3] = (byte)(this.dstInstance & 0xFFL);
        log.debug("Encoding Hello Request accomplished");
    }

    @Override
    public void decode(byte[] bytes, int offset) throws RSVPProtocolViolationException {
        log.debug("Starting Hello Request decode");
        int currentIndex = offset + 4;
        this.srcInstance = ByteHandler.decode4bytesLong(bytes, currentIndex);
        this.dstInstance = ByteHandler.decode4bytesLong(bytes, currentIndex += 4);
        log.debug("Decoding Hello Request accomplished");
    }

    public long getSrcInstance() {
        return this.srcInstance;
    }

    public void setSrcInstance(long srcInstance) {
        this.srcInstance = srcInstance;
    }

    public long getDstInstance() {
        return this.dstInstance;
    }

    public void setDstInstance(long dstInstance) {
        this.dstInstance = dstInstance;
    }
}

