/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects;

import es.tid.protocol.commons.ByteHandler;
import es.tid.rsvp.objects.FilterSpec;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FilterSpecLSPTunnelIPv4
extends FilterSpec {
    private Inet4Address senderNodeAddress;
    private int LSPId;
    private static final Logger log = LoggerFactory.getLogger((String)"ROADM");

    public FilterSpecLSPTunnelIPv4() {
        this.classNum = 10;
        this.cType = 7;
    }

    public FilterSpecLSPTunnelIPv4(Inet4Address senderNodeAddress, int LSPId) {
        this.classNum = 10;
        this.cType = 7;
        this.senderNodeAddress = senderNodeAddress;
        this.LSPId = LSPId;
        log.debug("Filter Spec LSP Tunnel IPv4 Object Created");
    }

    public FilterSpecLSPTunnelIPv4(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
        log.debug("Filter Spec LSP Tunnel IPv4 Object Created");
    }

    @Override
    public void encode() {
        this.length = 12;
        this.bytes = new byte[this.length];
        this.encodeHeader();
        byte[] addr = this.senderNodeAddress.getAddress();
        int currentIndex = 4;
        System.arraycopy(addr, 0, this.getBytes(), currentIndex, addr.length);
        this.bytes[currentIndex += addr.length] = 0;
        this.bytes[currentIndex + 1] = 0;
        this.bytes[currentIndex + 2] = (byte)(this.LSPId >> 8 & 0xFF);
        this.bytes[currentIndex + 3] = (byte)(this.LSPId & 0xFF);
        log.debug("Filter Spec LSP Tunnel IPv4 Object Encoded");
    }

    @Override
    public void decode() {
        int offset = 0;
        byte[] receivedAddress = new byte[4];
        System.arraycopy(this.bytes, offset += 4, receivedAddress, 0, 4);
        try {
            this.senderNodeAddress = (Inet4Address)Inet4Address.getByAddress(receivedAddress);
        }
        catch (UnknownHostException e) {
            log.error("Unknown Host received on Sender Template LSP IPv4 Object");
        }
        this.LSPId = ByteHandler.decode2bytesInteger(this.bytes, (offset += receivedAddress.length) + 2);
        log.debug("Filter Spec LSP Tunnel IPv4 Object Decoded");
    }

    public Inet4Address getSenderNodeAddress() {
        return this.senderNodeAddress;
    }

    public void setSenderNodeAddress(Inet4Address senderNodeAddress) {
        this.senderNodeAddress = senderNodeAddress;
    }

    public int getLSPId() {
        return this.LSPId;
    }

    public void setLSPId(int lSPId) {
        this.LSPId = lSPId;
    }
}

