/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects;

import es.tid.rsvp.objects.ErrorSpec;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public class ErrorSpecIPv4
extends ErrorSpec {
    protected Inet4Address errorNodeAddress;
    protected int flags;
    protected int errorCode;
    protected int errorValue;
    public static final int ERROR_SPEC_FLAG_IN_PLACE = 1;
    public static final int ERROR_SPEC_FLAG_GUILTY = 2;

    public ErrorSpecIPv4() {
        this.classNum = 6;
        this.cType = 1;
        this.flags = 0;
        this.errorCode = 0;
        this.errorValue = 0;
    }

    public ErrorSpecIPv4(Inet4Address errorNodeAddress, int flags, int errorCode, int errorValue) {
        this.classNum = 6;
        this.cType = 1;
        this.length = 12;
        this.bytes = new byte[this.length];
        this.errorNodeAddress = errorNodeAddress;
        this.flags = flags;
        this.errorCode = errorCode;
        this.errorValue = errorValue;
    }

    public ErrorSpecIPv4(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode(bytes, offset);
    }

    @Override
    public void encode() {
        this.length = 12;
        this.bytes = new byte[this.length];
        this.encodeHeader();
        if (this.errorNodeAddress == null) {
            try {
                this.errorNodeAddress = (Inet4Address)Inet4Address.getLocalHost();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        byte[] addr = this.errorNodeAddress.getAddress();
        System.arraycopy(addr, 0, this.getBytes(), 4, addr.length);
        this.bytes[8] = (byte)(this.flags & 0xFF);
        this.bytes[9] = (byte)(this.errorCode & 0xFF);
        this.bytes[10] = (byte)(this.errorValue >> 8 & 0xFF);
        this.bytes[11] = (byte)(this.errorValue & 0xFF);
    }

    public void decodeHeader() {
    }

    @Override
    public void decode(byte[] bytes, int offset) {
        this.length = bytes[offset] | bytes[offset + 1];
        int headerSize = 4;
        int unprocessedBytes = this.length - headerSize;
        int currentIndex = offset + headerSize;
        if (unprocessedBytes > 0) {
            byte[] readAddress = new byte[4];
            System.arraycopy(bytes, currentIndex, readAddress, 0, 4);
            try {
                this.errorNodeAddress = (Inet4Address)Inet4Address.getByAddress(readAddress);
                currentIndex += 4;
                unprocessedBytes -= 4;
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            if (unprocessedBytes > 0) {
                this.flags = bytes[currentIndex];
                ++currentIndex;
                if (--unprocessedBytes > 0) {
                    this.errorCode = bytes[currentIndex];
                    ++currentIndex;
                    if (--unprocessedBytes > 0) {
                        this.errorValue = bytes[currentIndex] | bytes[currentIndex + 1];
                        currentIndex += 2;
                        unprocessedBytes -= 2;
                    }
                }
            }
        }
    }

    public Inet4Address getErrorNodeAddress() {
        return this.errorNodeAddress;
    }

    public void setErrorNodeAddress(Inet4Address errorNodeAddress) {
        this.errorNodeAddress = errorNodeAddress;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    public int getErrorValue() {
        return this.errorValue;
    }

    public void setErrorValue(int errorValue) {
        this.errorValue = errorValue;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.errorCode;
        result = 31 * result + (this.errorNodeAddress == null ? 0 : this.errorNodeAddress.hashCode());
        result = 31 * result + this.errorValue;
        result = 31 * result + this.flags;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ErrorSpecIPv4 other = (ErrorSpecIPv4)obj;
        if (this.errorCode != other.errorCode) {
            return false;
        }
        if (this.errorNodeAddress == null ? other.errorNodeAddress != null : !this.errorNodeAddress.equals(other.errorNodeAddress)) {
            return false;
        }
        if (this.errorValue != other.errorValue) {
            return false;
        }
        return this.flags == other.flags;
    }
}

