/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.objects;

public class ControlledLoadService {
    private int perServiceHeader = 5;
    private int globalBreakBit;
    private int perServiceLength;
    private long serviceGeneralParameters;
    private byte[] bytes;
    private int length;

    public ControlledLoadService() {
        this.globalBreakBit = 0;
        this.perServiceLength = 0;
        this.length = 4;
        this.bytes = new byte[this.length];
    }

    public ControlledLoadService(long serviceGeneralParameters) {
        this.globalBreakBit = 8;
        this.perServiceLength = 1;
        this.serviceGeneralParameters = serviceGeneralParameters;
        this.length = 8;
        this.bytes = new byte[this.length];
    }

    public void encode() {
        int offset = 0;
        this.bytes[offset] = (byte)(this.perServiceHeader & 0xFF);
        this.bytes[offset + 1] = (byte)(this.globalBreakBit >> 7 & 0xFF);
        this.bytes[offset + 2] = (byte)(this.perServiceLength >> 8 & 0xFF);
        this.bytes[offset + 3] = (byte)(this.perServiceLength & 0xFF);
        if ((offset += 4) < this.length) {
            this.bytes[offset] = (byte)(this.serviceGeneralParameters >>> 24);
            this.bytes[offset + 1] = (byte)(this.serviceGeneralParameters >> 16 & 0xFFL);
            this.bytes[offset + 2] = (byte)(this.serviceGeneralParameters >> 8 & 0xFFL);
            this.bytes[offset + 3] = (byte)(this.serviceGeneralParameters & 0xFFL);
        }
    }

    public int getPerServiceHeader() {
        return this.perServiceHeader;
    }

    public void setPerServiceHeader(int perServiceHeader) {
        this.perServiceHeader = perServiceHeader;
    }

    public int getGlobalBreakBit() {
        return this.globalBreakBit;
    }

    public void setGlobalBreakBit(int globalBreakBit) {
        this.globalBreakBit = globalBreakBit;
    }

    public int getPerServiceLength() {
        return this.perServiceLength;
    }

    public void setPerServiceLength(int perServiceLength) {
        this.perServiceLength = perServiceLength;
    }

    public long getServiceGeneralParameters() {
        return this.serviceGeneralParameters;
    }

    public void setServiceGeneralParameters(long serviceGeneralParameters) {
        this.serviceGeneralParameters = serviceGeneralParameters;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public void setBytes(byte[] bytes) {
        this.bytes = bytes;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }
}

