/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.messages.te;

import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.SenderDescriptor;
import es.tid.rsvp.constructs.te.SenderDescriptorTE;
import es.tid.rsvp.messages.RSVPPathMessage;
import es.tid.rsvp.objects.ERO;
import es.tid.rsvp.objects.Integrity;
import es.tid.rsvp.objects.PolicyData;
import es.tid.rsvp.objects.RSVPHopIPv4;
import es.tid.rsvp.objects.RSVPHopIPv6;
import es.tid.rsvp.objects.RSVPObject;
import es.tid.rsvp.objects.SessionAttribute;
import es.tid.rsvp.objects.SessionAttributeWOResourceAffinities;
import es.tid.rsvp.objects.SessionAttributeWResourceAffinities;
import es.tid.rsvp.objects.SessionLSPTunnelIPv4;
import es.tid.rsvp.objects.SessionLSPTunnelIPv6;
import es.tid.rsvp.objects.TimeValues;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSVPTEPathMessage
extends RSVPPathMessage {
    private ERO ero;
    private SessionAttribute sessionAttribute;
    private static final Logger log = LoggerFactory.getLogger((String)"ROADM");

    public RSVPTEPathMessage() {
        this.vers = 1;
        this.flags = 0;
        this.msgType = 1;
        this.rsvpChecksum = 255;
        this.sendTTL = 0;
        this.reserved = 0;
        this.policyData = new LinkedList();
        this.senderDescriptors = new LinkedList();
        log.debug("RSVP-TE Path Message Created");
    }

    public RSVPTEPathMessage(byte[] bytes, int length) throws RSVPProtocolViolationException {
        super(bytes);
        this.decode();
        log.debug("RSVP TE Path Message Created");
        this.decode();
    }

    @Override
    public void encode() throws RSVPProtocolViolationException {
        log.debug("Starting RSVP-TE Path Message encode");
        this.rsvpChecksum = 255;
        this.length = 8;
        if (this.integrity != null) {
            this.integrity.encode();
            this.length += this.integrity.getLength();
            log.debug("Integrity RSVP Object found");
        }
        if (this.session != null) {
            this.session.encode();
            this.length += this.session.getLength();
        } else {
            log.error("Session RSVP Object NOT found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Session RSVP Object found");
        if (this.rsvpHop != null) {
            this.rsvpHop.encode();
            this.length += this.rsvpHop.getLength();
        } else {
            log.error("Hop RSVP Object NOT found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Hop RSVP Object found");
        if (this.timeValues != null) {
            this.timeValues.encode();
            this.length += this.timeValues.getLength();
        } else {
            log.error("Time Values RSVP Object NOT found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Time Values RSVP Object found");
        if (this.ero != null) {
            this.ero.encode();
            this.length += this.ero.getLength();
        } else {
            log.error("Label RSVP Object NOT found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("ERO RSVP Object found");
        if (this.sessionAttribute != null) {
            this.sessionAttribute.encode();
            this.length += this.sessionAttribute.getLength();
            log.debug("Session Attribute RSVP Object found");
        }
        int pdSize = this.policyData.size();
        int i = 0;
        while (i < pdSize) {
            PolicyData pd = (PolicyData)this.policyData.get(i);
            pd.encode();
            this.length += pd.getLength();
            log.debug("Policy Data RSVP Object found");
            ++i;
        }
        int sdSize = this.senderDescriptors.size();
        int i2 = 0;
        while (i2 < sdSize) {
            SenderDescriptor sd = (SenderDescriptor)this.senderDescriptors.get(i2);
            sd.encode();
            this.length += sd.getLength();
            log.debug("Sender Descriptor RSVP Construct found");
            ++i2;
        }
        this.bytes = new byte[this.length];
        this.encodeHeader();
        int currentIndex = 8;
        if (this.integrity != null) {
            System.arraycopy(this.integrity.getBytes(), 0, this.bytes, currentIndex, this.integrity.getLength());
            currentIndex += this.integrity.getLength();
        }
        System.arraycopy(this.session.getBytes(), 0, this.bytes, currentIndex, this.session.getLength());
        System.arraycopy(this.rsvpHop.getBytes(), 0, this.bytes, currentIndex += this.session.getLength(), this.rsvpHop.getLength());
        System.arraycopy(this.timeValues.getBytes(), 0, this.bytes, currentIndex += this.rsvpHop.getLength(), this.timeValues.getLength());
        currentIndex += this.timeValues.getLength();
        if (this.ero != null) {
            System.arraycopy(this.ero.getBytes(), 0, this.bytes, currentIndex, this.ero.getLength());
            currentIndex += this.ero.getLength();
        }
        if (this.sessionAttribute != null) {
            System.arraycopy(this.sessionAttribute.getBytes(), 0, this.bytes, currentIndex, this.sessionAttribute.getLength());
            currentIndex += this.sessionAttribute.getLength();
        }
        int i3 = 0;
        while (i3 < pdSize) {
            PolicyData pd = (PolicyData)this.policyData.get(i3);
            System.arraycopy(pd.getBytes(), 0, this.bytes, currentIndex, pd.getLength());
            currentIndex += pd.getLength();
            ++i3;
        }
        i3 = 0;
        while (i3 < sdSize) {
            SenderDescriptor sd = (SenderDescriptor)this.senderDescriptors.get(i3);
            System.arraycopy(sd.getBytes(), 0, this.bytes, currentIndex, sd.getLength());
            currentIndex += sd.getLength();
            ++i3;
        }
        this.calculateChecksum();
        log.debug("RSVP-TE Path Message encoding accomplished");
    }

    @Override
    public void decode() throws RSVPProtocolViolationException {
        this.decodeHeader();
        this.policyData = new LinkedList();
        this.senderDescriptors = new LinkedList();
        log.debug("RSVP-TE Path Message Decode started");
        int offset = 8;
        int num = 0;
        while (offset < this.length) {
            int cType;
            if (++num > 20) {
                throw new RSVPProtocolViolationException();
            }
            int classNum = RSVPObject.getClassNum(this.bytes, offset);
            if (classNum == 1) {
                cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 7) {
                    this.session = new SessionLSPTunnelIPv4(this.bytes, offset);
                    offset += this.session.getLength();
                    continue;
                }
                if (cType == 8) {
                    this.session = new SessionLSPTunnelIPv6(this.bytes, offset);
                    offset += this.session.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 3) {
                cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.rsvpHop = new RSVPHopIPv4(this.bytes, offset);
                    offset += this.rsvpHop.getLength();
                    continue;
                }
                if (cType == 2) {
                    this.rsvpHop = new RSVPHopIPv6(this.bytes, offset);
                    offset += this.rsvpHop.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 4) {
                cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.integrity = new Integrity(this.bytes, offset);
                    offset += this.integrity.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 5) {
                cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.timeValues = new TimeValues(this.bytes, offset);
                    offset += this.timeValues.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 20) {
                cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.ero = new ERO(this.bytes, offset);
                    offset += this.ero.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 207) {
                cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 7) {
                    this.sessionAttribute = new SessionAttributeWOResourceAffinities(this.bytes, offset);
                    offset += this.sessionAttribute.getLength();
                    continue;
                }
                if (cType == 1) {
                    this.sessionAttribute = new SessionAttributeWResourceAffinities(this.bytes, offset);
                    offset += this.sessionAttribute.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 14) {
                cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    PolicyData pd = new PolicyData(this.bytes, offset);
                    offset += pd.getLength();
                    this.policyData.add(pd);
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 11) {
                cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 7 || cType == 8) {
                    SenderDescriptorTE sd = new SenderDescriptorTE();
                    sd.decode(this.bytes, offset);
                    offset += sd.getLength();
                    this.addSenderDescriptor(sd);
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            throw new RSVPProtocolViolationException();
        }
        log.debug("RSVP-TE Path Message decoding accomplished");
    }

    @Override
    public void addSenderDescriptor(SenderDescriptor senderDescriptor) {
        this.senderDescriptors.add(senderDescriptor);
    }

    public ERO getEro() {
        return this.ero;
    }

    public void setEro(ERO ero) {
        this.ero = ero;
    }

    public SessionAttribute getSessionAttribute() {
        return this.sessionAttribute;
    }

    public void setSessionAttribute(SessionAttribute sessionAttribute) {
        this.sessionAttribute = sessionAttribute;
    }
}

