/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.messages.te;

import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.messages.RSVPMessage;
import es.tid.rsvp.objects.Hello;
import es.tid.rsvp.objects.HelloACK;
import es.tid.rsvp.objects.HelloRequest;
import es.tid.rsvp.objects.Integrity;
import es.tid.rsvp.objects.RSVPObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSVPTEHelloMessage
extends RSVPMessage {
    private Integrity integrity;
    private Hello hello;
    private static final Logger log = LoggerFactory.getLogger((String)"ROADM");

    public RSVPTEHelloMessage() {
        this.vers = 1;
        this.flags = 0;
        this.msgType = 20;
        this.rsvpChecksum = 255;
        this.sendTTL = 0;
        this.reserved = 0;
        log.debug("RSVP-TE Hello Message Created");
    }

    public RSVPTEHelloMessage(byte[] bytes, int length) throws RSVPProtocolViolationException {
        super(bytes);
        this.decode();
        log.debug("RSVP-TE Hello Message Created");
    }

    @Override
    public void encode() throws RSVPProtocolViolationException {
        this.length = 8;
        log.debug("RSVP-TE Hello Message Header encoding started");
        if (this.integrity != null) {
            this.integrity.encode();
            this.length += this.integrity.getLength();
            log.debug("Integrity RSVP Object found");
        }
        if (this.hello != null) {
            this.hello.encode();
            this.length += this.hello.getLength();
        } else {
            log.error("Hello RSVP Object NOT found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Hello RSVP Object found");
        this.bytes = new byte[this.length];
        this.encodeHeader();
        int currentIndex = 8;
        if (this.integrity != null) {
            System.arraycopy(this.integrity.getBytes(), 0, this.bytes, currentIndex, this.integrity.getLength());
            currentIndex += this.integrity.getLength();
        }
        System.arraycopy(this.hello.getBytes(), 0, this.bytes, currentIndex, this.hello.getLength());
        currentIndex += this.hello.getLength();
        log.debug("RSVP-TE Hello Message encoding accomplished");
    }

    @Override
    public void decode() throws RSVPProtocolViolationException {
        this.decodeHeader();
        int offset = 8;
        while (offset < this.length) {
            int cType;
            int classNum = RSVPObject.getClassNum(this.bytes, offset);
            if (classNum == 4) {
                cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.integrity = new Integrity(this.bytes, offset);
                    offset += this.integrity.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 22) {
                cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.hello = new HelloRequest(this.bytes, offset);
                    this.hello.decode(this.bytes, offset);
                    offset += this.hello.getLength();
                    continue;
                }
                if (cType == 2) {
                    this.hello = new HelloACK(this.bytes, offset);
                    this.hello.decode(this.bytes, offset);
                    offset += this.hello.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            throw new RSVPProtocolViolationException();
        }
    }

    public Integrity getIntegrity() {
        return this.integrity;
    }

    public void setIntegrity(Integrity integrity) {
        this.integrity = integrity;
    }

    public Hello getHello() {
        return this.hello;
    }

    public void setHello(Hello hello) {
        this.hello = hello;
    }
}

