/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.messages;

import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.FFFlowDescriptor;
import es.tid.rsvp.constructs.FlowDescriptor;
import es.tid.rsvp.constructs.SEFlowDescriptor;
import es.tid.rsvp.constructs.WFFlowDescriptor;
import es.tid.rsvp.messages.RSVPMessage;
import es.tid.rsvp.objects.Integrity;
import es.tid.rsvp.objects.PolicyData;
import es.tid.rsvp.objects.RSVPHop;
import es.tid.rsvp.objects.RSVPHopIPv4;
import es.tid.rsvp.objects.RSVPHopIPv6;
import es.tid.rsvp.objects.RSVPObject;
import es.tid.rsvp.objects.ResvConfirm;
import es.tid.rsvp.objects.ResvConfirmIPv4;
import es.tid.rsvp.objects.ResvConfirmIPv6;
import es.tid.rsvp.objects.Scope;
import es.tid.rsvp.objects.ScopeIPv4;
import es.tid.rsvp.objects.ScopeIPv6;
import es.tid.rsvp.objects.Session;
import es.tid.rsvp.objects.SessionIPv4;
import es.tid.rsvp.objects.SessionIPv6;
import es.tid.rsvp.objects.Style;
import es.tid.rsvp.objects.TimeValues;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSVPResvMessage
extends RSVPMessage {
    protected Integrity integrity;
    protected Session session;
    protected RSVPHop rsvpHop;
    protected TimeValues timeValues;
    protected ResvConfirm resvConfirm;
    protected Scope scope;
    protected LinkedList<PolicyData> policyData;
    protected Style style;
    protected LinkedList<FlowDescriptor> flowDescriptors;
    private static final Logger log = LoggerFactory.getLogger((String)"ROADM");

    public RSVPResvMessage() {
        this.vers = 1;
        this.flags = 0;
        this.msgType = 2;
        this.rsvpChecksum = 255;
        this.sendTTL = 0;
        this.reserved = 0;
        this.policyData = new LinkedList();
        this.flowDescriptors = new LinkedList();
        log.debug("RSVP Resv Message Created");
    }

    public RSVPResvMessage(byte[] bytes, int length) throws RSVPProtocolViolationException {
        super(bytes);
        this.decode();
        log.debug("RSVP Resv Message Created");
    }

    @Override
    public void encode() throws RSVPProtocolViolationException {
        log.debug("Starting RSVP Resv Message encode");
        this.length = 8;
        this.rsvpChecksum = 255;
        if (this.integrity != null) {
            this.integrity.encode();
            this.length += this.integrity.getLength();
            log.debug("Integrity RSVP Object found");
        }
        if (this.session != null) {
            this.session.encode();
            this.length += this.session.getLength();
        } else {
            log.error("Session RSVP Object NOT found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Session RSVP Object found");
        if (this.rsvpHop != null) {
            this.rsvpHop.encode();
            this.length += this.rsvpHop.getLength();
        } else {
            log.error("Hop RSVP Object NOT found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Hop RSVP Object found");
        if (this.timeValues != null) {
            this.timeValues.encode();
            this.length += this.timeValues.getLength();
        } else {
            log.error("Time Values RSVP Object NOT found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Time Values RSVP Object found");
        if (this.resvConfirm != null) {
            this.resvConfirm.encode();
            this.length += this.resvConfirm.getLength();
            log.debug("ResvConfirm RSVP Object found");
        }
        if (this.scope != null) {
            this.scope.encode();
            this.length += this.scope.getLength();
            log.debug("Scope RSVP Object found");
        }
        int pdSize = this.policyData.size();
        int i = 0;
        while (i < pdSize) {
            PolicyData pd = this.policyData.get(i);
            pd.encode();
            this.length += pd.getLength();
            log.debug("Policy Data RSVP Object found");
            ++i;
        }
        if (this.style != null) {
            this.style.encode();
            this.length += this.style.getLength();
        } else {
            log.error("Style RSVP Object NOT found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Style RSVP Object found");
        int fdSize = this.flowDescriptors.size();
        int i2 = 0;
        while (i2 < fdSize) {
            FlowDescriptor fd = this.flowDescriptors.get(i2);
            try {
                fd.encode();
            }
            catch (RSVPProtocolViolationException e) {
                log.error("Errors during Flow Descriptor number " + i2 + " encoding");
            }
            this.length += fd.getLength();
            log.debug("Sender Descriptor RSVP Construct found");
            ++i2;
        }
        this.bytes = new byte[this.length];
        this.encodeHeader();
        int currentIndex = 8;
        if (this.integrity != null) {
            System.arraycopy(this.integrity.getBytes(), 0, this.bytes, currentIndex, this.integrity.getLength());
            currentIndex += this.integrity.getLength();
        }
        System.arraycopy(this.session.getBytes(), 0, this.bytes, currentIndex, this.session.getLength());
        System.arraycopy(this.rsvpHop.getBytes(), 0, this.bytes, currentIndex += this.session.getLength(), this.rsvpHop.getLength());
        System.arraycopy(this.timeValues.getBytes(), 0, this.bytes, currentIndex += this.rsvpHop.getLength(), this.timeValues.getLength());
        currentIndex += this.timeValues.getLength();
        if (this.resvConfirm != null) {
            System.arraycopy(this.resvConfirm.getBytes(), 0, this.bytes, currentIndex, this.resvConfirm.getLength());
            currentIndex += this.resvConfirm.getLength();
        }
        if (this.scope != null) {
            System.arraycopy(this.scope.getBytes(), 0, this.bytes, currentIndex, this.scope.getLength());
            currentIndex += this.scope.getLength();
        }
        int i3 = 0;
        while (i3 < pdSize) {
            PolicyData pd = this.policyData.get(i3);
            System.arraycopy(pd.getBytes(), 0, this.bytes, currentIndex, pd.getLength());
            currentIndex += pd.getLength();
            ++i3;
        }
        System.arraycopy(this.style.getBytes(), 0, this.bytes, currentIndex, this.style.getLength());
        currentIndex += this.style.getLength();
        i3 = 0;
        while (i3 < fdSize) {
            FlowDescriptor fd = this.flowDescriptors.get(i3);
            System.arraycopy(fd.getBytes(), 0, this.bytes, currentIndex, fd.getLength());
            currentIndex += fd.getLength();
            ++i3;
        }
        log.debug("RSVP Resv Message encoding accomplished");
    }

    @Override
    public void decode() throws RSVPProtocolViolationException {
        this.policyData = new LinkedList();
        this.flowDescriptors = new LinkedList();
        int offset = 8;
        while (offset < this.length) {
            int classNum = RSVPObject.getClassNum(this.bytes, offset);
            if (classNum == 1) {
                int cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.session = new SessionIPv4(this.bytes, offset);
                    offset += this.session.getLength();
                    continue;
                }
                if (cType == 2) {
                    this.session = new SessionIPv6(this.bytes, offset);
                    offset += this.session.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 3) {
                int cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.rsvpHop = new RSVPHopIPv4(this.bytes, offset);
                    offset += this.rsvpHop.getLength();
                    continue;
                }
                if (cType == 2) {
                    this.rsvpHop = new RSVPHopIPv6(this.bytes, offset);
                    offset += this.rsvpHop.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 4) {
                int cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.integrity = new Integrity(this.bytes, offset);
                    offset += this.integrity.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 5) {
                int cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.timeValues = new TimeValues(this.bytes, offset);
                    offset += this.timeValues.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 15) {
                int cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.resvConfirm = new ResvConfirmIPv4(this.bytes, offset);
                    offset += this.resvConfirm.getLength();
                    continue;
                }
                if (cType == 2) {
                    this.resvConfirm = new ResvConfirmIPv6(this.bytes, offset);
                    offset += this.resvConfirm.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 7) {
                int cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.scope = new ScopeIPv4(this.bytes, offset);
                    offset += this.scope.getLength();
                    continue;
                }
                if (cType == 2) {
                    this.scope = new ScopeIPv6(this.bytes, offset);
                    offset += this.scope.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 14) {
                int cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    PolicyData pd = new PolicyData(this.bytes, offset);
                    offset += pd.getLength();
                    this.policyData.add(pd);
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 8) {
                int cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.style = new Style(this.bytes, offset);
                    offset += this.style.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 9) {
                if (this.style != null) {
                    if (this.style.getOptionVector() == 10) {
                        FFFlowDescriptor fffd = new FFFlowDescriptor(true);
                        fffd.decode(this.bytes, offset);
                        offset += fffd.getLength();
                        this.flowDescriptors.add(fffd);
                        while (offset < this.length) {
                            FFFlowDescriptor fffd2 = new FFFlowDescriptor(false);
                            fffd2.decode(this.bytes, offset);
                            offset += fffd2.getLength();
                            this.flowDescriptors.add(fffd2);
                        }
                        continue;
                    }
                    if (this.style.getOptionVector() == 17) {
                        while (offset < this.length) {
                            WFFlowDescriptor wffd = new WFFlowDescriptor();
                            wffd.decode(this.bytes, offset);
                            offset += wffd.getLength();
                            this.flowDescriptors.add(wffd);
                        }
                        continue;
                    }
                    if (this.style.getOptionVector() != 18) continue;
                    while (offset < this.length) {
                        SEFlowDescriptor sefd = new SEFlowDescriptor();
                        sefd.decode(this.bytes, offset);
                        offset += sefd.getLength();
                        this.flowDescriptors.add(sefd);
                    }
                    continue;
                }
                log.error("Malformed RSVP Resv Message, Style Object not Found");
                throw new RSVPProtocolViolationException();
            }
            log.error("Malformed RSVP Resv Message, Object classNum incorrect");
            throw new RSVPProtocolViolationException();
        }
    }

    public void addFlowDescriptor(FFFlowDescriptor flowDescriptor) {
        this.flowDescriptors.add(flowDescriptor);
    }

    public Integrity getIntegrity() {
        return this.integrity;
    }

    public void setIntegrity(Integrity integrity) {
        this.integrity = integrity;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public RSVPHop getRsvpHop() {
        return this.rsvpHop;
    }

    public void setRsvpHop(RSVPHop rsvpHop) {
        this.rsvpHop = rsvpHop;
    }

    public TimeValues getTimeValues() {
        return this.timeValues;
    }

    public void setTimeValues(TimeValues timeValues) {
        this.timeValues = timeValues;
    }

    public ResvConfirm getResvConfirm() {
        return this.resvConfirm;
    }

    public void setResvConfirm(ResvConfirm resvConfirm) {
        this.resvConfirm = resvConfirm;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public LinkedList<PolicyData> getPolicyData() {
        return this.policyData;
    }

    public void setPolicyData(LinkedList<PolicyData> policyData) {
        this.policyData = policyData;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public LinkedList<FlowDescriptor> getFlowDescriptors() {
        return this.flowDescriptors;
    }

    public void setFlowDescriptors(LinkedList<FlowDescriptor> flowDescriptors) {
        this.flowDescriptors = flowDescriptors;
    }
}

