/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.messages;

import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.ErrorFlowDescriptor;
import es.tid.rsvp.constructs.FFErrorFlowDescriptor;
import es.tid.rsvp.constructs.SEErrorFlowDescriptor;
import es.tid.rsvp.constructs.WFErrorFlowDescriptor;
import es.tid.rsvp.messages.RSVPMessage;
import es.tid.rsvp.objects.ErrorSpec;
import es.tid.rsvp.objects.ErrorSpecIPv4;
import es.tid.rsvp.objects.ErrorSpecIPv6;
import es.tid.rsvp.objects.Integrity;
import es.tid.rsvp.objects.PolicyData;
import es.tid.rsvp.objects.RSVPHop;
import es.tid.rsvp.objects.RSVPHopIPv4;
import es.tid.rsvp.objects.RSVPHopIPv6;
import es.tid.rsvp.objects.RSVPObject;
import es.tid.rsvp.objects.Scope;
import es.tid.rsvp.objects.ScopeIPv4;
import es.tid.rsvp.objects.ScopeIPv6;
import es.tid.rsvp.objects.Session;
import es.tid.rsvp.objects.SessionIPv4;
import es.tid.rsvp.objects.SessionIPv6;
import es.tid.rsvp.objects.Style;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSVPResvErrMessage
extends RSVPMessage {
    private Integrity integrity;
    private Session session;
    private RSVPHop rsvpHop;
    private ErrorSpec errorSpec;
    private Scope scope;
    private LinkedList<PolicyData> policyData;
    private Style style;
    private ErrorFlowDescriptor errorFlowDescriptor;
    private static final Logger log = LoggerFactory.getLogger((String)"ROADM");

    public RSVPResvErrMessage() {
        this.vers = 1;
        this.flags = 0;
        this.msgType = 2;
        this.rsvpChecksum = 255;
        this.sendTTL = 0;
        this.reserved = 0;
        this.length = 8;
        this.policyData = new LinkedList();
        log.debug("RSVP Resv Error Message Created");
    }

    public RSVPResvErrMessage(byte[] bytes, int length) throws RSVPProtocolViolationException {
        super(bytes);
        this.decode();
        log.debug("RSVP Resv Error Message Created");
    }

    @Override
    public void encode() throws RSVPProtocolViolationException {
        int commonHeaderSize;
        log.debug("Starting RSVP Resv Error Message encode");
        this.rsvpChecksum = 255;
        this.length = commonHeaderSize = 8;
        if (this.integrity != null) {
            this.integrity.encode();
            this.length += this.integrity.getLength();
            log.debug("Integrity RSVP Object found ");
        }
        if (this.session != null) {
            this.session.encode();
            this.length += this.session.getLength();
        } else {
            log.error("Session RSVP Object NOT found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Session RSVP Object found");
        if (this.rsvpHop != null) {
            this.rsvpHop.encode();
            this.length += this.rsvpHop.getLength();
        } else {
            log.error("Hop RSVP Object NOT found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Hop RSVP Object found");
        if (this.errorSpec != null) {
            this.errorSpec.encode();
            this.length += this.errorSpec.getLength();
        } else {
            log.error("Error Spec RSVP Object NOT found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Error Spec RSVP Object found");
        if (this.scope != null) {
            this.scope.encode();
            this.length += this.scope.getLength();
            log.debug("Scope RSVP Object found");
        }
        int pdSize = this.policyData.size();
        int i = 0;
        while (i < pdSize) {
            PolicyData pd = this.policyData.get(i);
            pd.encode();
            this.length += pd.getLength();
            log.debug("Policy Data RSVP Object found");
            ++i;
        }
        if (this.style != null) {
            this.style.encode();
            this.length += this.style.getLength();
        } else {
            log.error("Style RSVP Object NOT found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Style RSVP Object found");
        if (this.errorFlowDescriptor != null) {
            try {
                this.errorFlowDescriptor.encode();
                this.length += this.errorFlowDescriptor.getLength();
                log.debug("Error Flow RSVP Construct found");
            }
            catch (RSVPProtocolViolationException e) {
                log.error("Failure encoding error Flow descriptor on RSVP Resv Error Message");
            }
        }
        System.out.println("total lenght es " + this.length);
        this.bytes = new byte[this.length];
        this.encodeHeader();
        int currentIndex = commonHeaderSize;
        if (this.integrity != null) {
            System.arraycopy(this.integrity.getBytes(), 0, this.bytes, currentIndex, this.integrity.getLength());
            currentIndex += this.integrity.getLength();
        }
        System.arraycopy(this.session.getBytes(), 0, this.bytes, currentIndex, this.session.getLength());
        System.arraycopy(this.rsvpHop.getBytes(), 0, this.bytes, currentIndex += this.session.getLength(), this.rsvpHop.getLength());
        System.arraycopy(this.errorSpec.getBytes(), 0, this.bytes, currentIndex += this.rsvpHop.getLength(), this.errorSpec.getLength());
        currentIndex += this.errorSpec.getLength();
        if (this.scope != null) {
            System.arraycopy(this.scope.getBytes(), 0, this.bytes, currentIndex, this.scope.getLength());
            currentIndex += this.scope.getLength();
        }
        int i2 = 0;
        while (i2 < pdSize) {
            PolicyData pd = this.policyData.get(i2);
            System.arraycopy(pd.getBytes(), 0, this.bytes, currentIndex, pd.getLength());
            currentIndex += pd.getLength();
            ++i2;
        }
        System.arraycopy(this.style.getBytes(), 0, this.bytes, currentIndex, this.style.getLength());
        currentIndex += this.style.getLength();
        if (this.errorFlowDescriptor != null) {
            System.arraycopy(this.errorFlowDescriptor.getBytes(), 0, this.bytes, currentIndex, this.errorFlowDescriptor.getLength());
            currentIndex += this.errorFlowDescriptor.getLength();
        }
        log.debug("RSVP Resv Error Message encoding accomplished");
    }

    @Override
    public void decode() throws RSVPProtocolViolationException {
        this.policyData = new LinkedList();
        int offset = 8;
        while (offset < this.length) {
            int cType;
            int classNum = RSVPObject.getClassNum(this.bytes, offset);
            if (classNum == 1) {
                cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.session = new SessionIPv4(this.bytes, offset);
                    offset += this.session.getLength();
                    continue;
                }
                if (cType == 2) {
                    this.session = new SessionIPv6(this.bytes, offset);
                    offset += this.session.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 3) {
                cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.rsvpHop = new RSVPHopIPv4(this.bytes, offset);
                    offset += this.rsvpHop.getLength();
                    continue;
                }
                if (cType == 2) {
                    this.rsvpHop = new RSVPHopIPv6(this.bytes, offset);
                    offset += this.rsvpHop.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 4) {
                cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.integrity = new Integrity(this.bytes, offset);
                    offset += this.integrity.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 6) {
                cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.errorSpec = new ErrorSpecIPv4(this.bytes, offset);
                    offset += this.errorSpec.getLength();
                    continue;
                }
                if (cType == 2) {
                    this.errorSpec = new ErrorSpecIPv6(this.bytes, offset);
                    offset += this.errorSpec.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 7) {
                cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.scope = new ScopeIPv4(this.bytes, offset);
                    offset += this.scope.getLength();
                    continue;
                }
                if (cType == 2) {
                    this.scope = new ScopeIPv6(this.bytes, offset);
                    offset += this.scope.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 14) {
                cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    PolicyData pd = new PolicyData(this.bytes, offset);
                    offset += pd.getLength();
                    this.policyData.add(pd);
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 8) {
                cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.style = new Style(this.bytes, offset);
                    offset += this.style.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 9) {
                if (this.style != null) {
                    if (this.style.getOptionVector() == 10) {
                        this.errorFlowDescriptor = new FFErrorFlowDescriptor();
                        this.errorFlowDescriptor.decode(this.bytes, offset);
                        offset += this.errorFlowDescriptor.getLength();
                        continue;
                    }
                    if (this.style.getOptionVector() == 17) {
                        this.errorFlowDescriptor = new WFErrorFlowDescriptor();
                        this.errorFlowDescriptor.decode(this.bytes, offset);
                        offset += this.errorFlowDescriptor.getLength();
                        continue;
                    }
                    if (this.style.getOptionVector() != 18) continue;
                    this.errorFlowDescriptor = new SEErrorFlowDescriptor();
                    this.errorFlowDescriptor.decode(this.bytes, offset);
                    offset += this.errorFlowDescriptor.getLength();
                    continue;
                }
                log.error("Malformed RSVP Resv Error Message, Style Object not Found");
                throw new RSVPProtocolViolationException();
            }
            log.error("Malformed RSVP Resv Error Message, Object classNum incorrect");
            throw new RSVPProtocolViolationException();
        }
    }

    public Integrity getIntegrity() {
        return this.integrity;
    }

    public void setIntegrity(Integrity integrity) {
        this.integrity = integrity;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public RSVPHop getRsvpHop() {
        return this.rsvpHop;
    }

    public void setRsvpHop(RSVPHop rsvpHop) {
        this.rsvpHop = rsvpHop;
    }

    public ErrorSpec getErrorSpec() {
        return this.errorSpec;
    }

    public void setErrorSpec(ErrorSpec errorSpec) {
        this.errorSpec = errorSpec;
    }

    public Scope getScope() {
        return this.scope;
    }

    public void setScope(Scope scope) {
        this.scope = scope;
    }

    public LinkedList<PolicyData> getPolicyData() {
        return this.policyData;
    }

    public void setPolicyData(LinkedList<PolicyData> policyData) {
        this.policyData = policyData;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public ErrorFlowDescriptor getErrorFlowDescriptor() {
        return this.errorFlowDescriptor;
    }

    public void setErrorFlowDescriptor(ErrorFlowDescriptor errorFlowDescriptor) {
        this.errorFlowDescriptor = errorFlowDescriptor;
    }
}

