/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.messages;

import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.FFFlowDescriptor;
import es.tid.rsvp.constructs.FlowDescriptor;
import es.tid.rsvp.constructs.SEFlowDescriptor;
import es.tid.rsvp.constructs.WFFlowDescriptor;
import es.tid.rsvp.messages.RSVPMessage;
import es.tid.rsvp.objects.ErrorSpec;
import es.tid.rsvp.objects.ErrorSpecIPv4;
import es.tid.rsvp.objects.ErrorSpecIPv6;
import es.tid.rsvp.objects.Integrity;
import es.tid.rsvp.objects.RSVPObject;
import es.tid.rsvp.objects.ResvConfirm;
import es.tid.rsvp.objects.ResvConfirmIPv4;
import es.tid.rsvp.objects.ResvConfirmIPv6;
import es.tid.rsvp.objects.Session;
import es.tid.rsvp.objects.SessionIPv4;
import es.tid.rsvp.objects.SessionIPv6;
import es.tid.rsvp.objects.Style;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSVPResvConfMessage
extends RSVPMessage {
    private Integrity integrity;
    private Session session;
    private ErrorSpec errorSpec;
    private ResvConfirm resvConfirm;
    private Style style;
    private LinkedList<FlowDescriptor> flowDescriptors;
    private static final Logger log = LoggerFactory.getLogger((String)"ROADM");

    public RSVPResvConfMessage() {
        this.vers = 1;
        this.flags = 0;
        this.msgType = 7;
        this.rsvpChecksum = 255;
        this.sendTTL = 0;
        this.reserved = 0;
        this.length = 8;
        this.flowDescriptors = new LinkedList();
        log.debug("RSVP Resv Confirmation Message Created");
    }

    public RSVPResvConfMessage(byte[] bytes, int length) throws RSVPProtocolViolationException {
        super(bytes);
        this.decode();
        log.debug("RSVP Resv Confirmation Message Created");
    }

    @Override
    public void encodeHeader() {
        this.bytes[0] = (byte)(this.vers << 4 & 0xF0 | this.flags & 0xF);
        this.bytes[1] = (byte)this.msgType;
        this.bytes[2] = (byte)(this.rsvpChecksum >> 8 & 0xFF);
        this.bytes[3] = (byte)(this.rsvpChecksum & 0xFF);
        this.bytes[4] = (byte)this.sendTTL;
        this.bytes[5] = (byte)this.reserved;
        this.bytes[6] = (byte)(this.length >> 8 & 0xFF);
        this.bytes[7] = (byte)(this.length & 0xFF);
    }

    @Override
    public void encode() throws RSVPProtocolViolationException {
        log.debug("Starting RSVP Resv Message encode");
        this.rsvpChecksum = 255;
        int commonHeaderSize = 8;
        this.length = 8;
        if (this.integrity != null) {
            this.integrity.encode();
            this.length += this.integrity.getLength();
            log.debug("Integrity RSVP Object found");
        }
        if (this.session != null) {
            this.session.encode();
            this.length += this.session.getLength();
        } else {
            log.error("Session RSVP Object NOT found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Session RSVP Object found");
        if (this.errorSpec != null) {
            this.errorSpec.encode();
            this.length += this.errorSpec.getLength();
        } else {
            log.error("Error Spec RSVP Object NOT found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Error Spec RSVP Object found");
        if (this.resvConfirm != null) {
            this.resvConfirm.encode();
            this.length += this.resvConfirm.getLength();
        } else {
            log.error("Resv Confirm RSVP Object NOT found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("ResvConfirm RSVP Object found");
        if (this.style != null) {
            this.style.encode();
            this.length += this.style.getLength();
        } else {
            log.error("Style RSVP Object NOT found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Style RSVP Object found");
        int fdSize = this.flowDescriptors.size();
        int i = 0;
        while (i < fdSize) {
            FlowDescriptor fd = this.flowDescriptors.get(i);
            try {
                fd.encode();
                this.length += fd.getLength();
                log.debug("Flow Descriptor RSVP Construct found");
            }
            catch (RSVPProtocolViolationException e) {
                log.error("Errors during Flow Descriptor number " + i + " encoding");
            }
            ++i;
        }
        this.bytes = new byte[this.length];
        this.encodeHeader();
        int currentIndex = commonHeaderSize;
        if (this.integrity != null) {
            System.arraycopy(this.integrity.getBytes(), 0, this.bytes, currentIndex, this.integrity.getLength());
            currentIndex += this.integrity.getLength();
        }
        System.arraycopy(this.session.getBytes(), 0, this.bytes, currentIndex, this.session.getLength());
        System.arraycopy(this.errorSpec.getBytes(), 0, this.bytes, currentIndex += this.session.getLength(), this.errorSpec.getLength());
        System.arraycopy(this.resvConfirm.getBytes(), 0, this.bytes, currentIndex += this.errorSpec.getLength(), this.resvConfirm.getLength());
        System.arraycopy(this.style.getBytes(), 0, this.bytes, currentIndex += this.resvConfirm.getLength(), this.style.getLength());
        currentIndex += this.style.getLength();
        int i2 = 0;
        while (i2 < fdSize) {
            FlowDescriptor fd = this.flowDescriptors.get(i2);
            System.arraycopy(fd.getBytes(), 0, this.bytes, currentIndex, fd.getLength());
            currentIndex += fd.getLength();
            ++i2;
        }
        log.debug("RSVP Resv Confirmation Message encoding accomplished");
    }

    @Override
    public void decode() throws RSVPProtocolViolationException {
        this.decodeHeader();
        this.flowDescriptors = new LinkedList();
        int offset = 8;
        while (offset < this.length) {
            int classNum = RSVPObject.getClassNum(this.bytes, offset);
            if (classNum == 1) {
                int cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.session = new SessionIPv4(this.bytes, offset);
                    offset += this.session.getLength();
                    continue;
                }
                if (cType == 2) {
                    this.session = new SessionIPv6(this.bytes, offset);
                    offset += this.session.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 6) {
                int cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.errorSpec = new ErrorSpecIPv4(this.bytes, offset);
                    offset += this.errorSpec.getLength();
                    continue;
                }
                if (cType == 2) {
                    this.errorSpec = new ErrorSpecIPv6(this.bytes, offset);
                    offset += this.errorSpec.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 4) {
                int cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.integrity = new Integrity(this.bytes, offset);
                    offset += this.integrity.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 15) {
                int cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.resvConfirm = new ResvConfirmIPv4(this.bytes, offset);
                    offset += this.resvConfirm.getLength();
                    continue;
                }
                if (cType == 2) {
                    this.resvConfirm = new ResvConfirmIPv6(this.bytes, offset);
                    offset += this.resvConfirm.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 8) {
                int cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.style = new Style(this.bytes, offset);
                    offset += this.style.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 9) {
                if (this.style != null) {
                    if (this.style.getOptionVector() == 10) {
                        FFFlowDescriptor fffd = new FFFlowDescriptor(true);
                        fffd.decode(this.bytes, offset);
                        offset += fffd.getLength();
                        this.flowDescriptors.add(fffd);
                        while (offset < this.length) {
                            FFFlowDescriptor fffd2 = new FFFlowDescriptor(true);
                            fffd2.decode(this.bytes, offset);
                            offset += fffd2.getLength();
                            this.flowDescriptors.add(fffd2);
                        }
                        continue;
                    }
                    if (this.style.getOptionVector() == 17) {
                        while (offset < this.length) {
                            WFFlowDescriptor wffd = new WFFlowDescriptor();
                            wffd.decode(this.bytes, offset);
                            offset += wffd.getLength();
                            this.flowDescriptors.add(wffd);
                        }
                        continue;
                    }
                    if (this.style.getOptionVector() != 18) continue;
                    while (offset < this.length) {
                        SEFlowDescriptor sefd = new SEFlowDescriptor();
                        sefd.decode(this.bytes, offset);
                        offset += sefd.getLength();
                        this.flowDescriptors.add(sefd);
                    }
                    continue;
                }
                log.error("Malformed RSVP Resv Confirmation Message, Style Object not Found");
                throw new RSVPProtocolViolationException();
            }
            log.error("Malformed RSVP Resv Confirmation Message, Object classNum incorrect");
            throw new RSVPProtocolViolationException();
        }
    }

    public Integrity getIntegrity() {
        return this.integrity;
    }

    public void setIntegrity(Integrity integrity) {
        this.integrity = integrity;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public ErrorSpec getErrorSpec() {
        return this.errorSpec;
    }

    public void setErrorSpec(ErrorSpec errorSpec) {
        this.errorSpec = errorSpec;
    }

    public ResvConfirm getResvConfirm() {
        return this.resvConfirm;
    }

    public void setResvConfirm(ResvConfirm resvConfirm) {
        this.resvConfirm = resvConfirm;
    }

    public Style getStyle() {
        return this.style;
    }

    public void setStyle(Style style) {
        this.style = style;
    }

    public LinkedList<FlowDescriptor> getFlowDescriptors() {
        return this.flowDescriptors;
    }

    public void setFlowDescriptors(LinkedList<FlowDescriptor> flowDescriptors) {
        this.flowDescriptors = flowDescriptors;
    }
}

