/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.messages;

import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.SenderDescriptor;
import es.tid.rsvp.messages.RSVPMessage;
import es.tid.rsvp.objects.ErrorSpec;
import es.tid.rsvp.objects.ErrorSpecIPv4;
import es.tid.rsvp.objects.ErrorSpecIPv6;
import es.tid.rsvp.objects.Integrity;
import es.tid.rsvp.objects.PolicyData;
import es.tid.rsvp.objects.RSVPObject;
import es.tid.rsvp.objects.Session;
import es.tid.rsvp.objects.SessionIPv4;
import es.tid.rsvp.objects.SessionIPv6;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RSVPPathErrMessage
extends RSVPMessage {
    private Integrity integrity;
    private Session session;
    private ErrorSpec errorSpec;
    private LinkedList<PolicyData> policyData;
    private LinkedList<SenderDescriptor> senderDescriptors;
    private static final Logger log = LoggerFactory.getLogger((String)"ROADM");

    public RSVPPathErrMessage() {
        this.vers = 1;
        this.flags = 0;
        this.msgType = 3;
        this.rsvpChecksum = 255;
        this.sendTTL = 0;
        this.reserved = 0;
        this.length = 8;
        this.policyData = new LinkedList();
        this.senderDescriptors = new LinkedList();
        log.debug("RSVP Path Error Message Created");
    }

    public RSVPPathErrMessage(byte[] bytes, int length) throws RSVPProtocolViolationException {
        super(bytes);
        this.decode();
        log.debug("RSVP Path Error Message Created");
    }

    @Override
    public void encode() throws RSVPProtocolViolationException {
        int commonHeaderSize;
        log.debug("Starting RSVP Path Error Message encode");
        this.rsvpChecksum = 255;
        this.length = commonHeaderSize = 8;
        if (this.integrity != null) {
            this.integrity.encode();
            this.length += this.integrity.getLength();
            log.debug("Integrity RSVP Object found");
        }
        if (this.session != null) {
            this.session.encode();
            this.length += this.session.getLength();
        } else {
            log.error("Session RSVP Object NOT found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Session RSVP Object found");
        if (this.errorSpec != null) {
            this.errorSpec.encode();
            this.length += this.errorSpec.getLength();
        } else {
            log.error("ErrorSpec RSVP Object NOT found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("ErrorSpec RSVP Object found");
        int pdSize = this.policyData.size();
        int i = 0;
        while (i < pdSize) {
            PolicyData pd = this.policyData.get(i);
            pd.encode();
            this.length += pd.getLength();
            log.debug("Policy Data RSVP Object found");
            ++i;
        }
        int sdSize = this.senderDescriptors.size();
        int i2 = 0;
        while (i2 < sdSize) {
            SenderDescriptor sd = this.senderDescriptors.get(i2);
            try {
                sd.encode();
                this.length += sd.getLength();
                log.debug("Sender Descriptor RSVP Construct found");
            }
            catch (RSVPProtocolViolationException e) {
                log.error("Errors during Sender Descriptor number " + i2 + " encoding");
            }
            ++i2;
        }
        this.bytes = new byte[this.length];
        this.encodeHeader();
        int currentIndex = commonHeaderSize;
        if (this.integrity != null) {
            System.arraycopy(this.integrity.getBytes(), 0, this.bytes, currentIndex, this.integrity.getLength());
            currentIndex += this.integrity.getLength();
        }
        System.arraycopy(this.session.getBytes(), 0, this.bytes, currentIndex, this.session.getLength());
        System.arraycopy(this.errorSpec.getBytes(), 0, this.bytes, currentIndex += this.session.getLength(), this.errorSpec.getLength());
        currentIndex += this.errorSpec.getLength();
        int i3 = 0;
        while (i3 < pdSize) {
            PolicyData pd = this.policyData.get(i3);
            System.arraycopy(pd.getBytes(), 0, this.bytes, currentIndex, pd.getLength());
            currentIndex += pd.getLength();
            ++i3;
        }
        i3 = 0;
        while (i3 < sdSize) {
            SenderDescriptor sd = this.senderDescriptors.get(i3);
            System.arraycopy(sd.getBytes(), 0, this.bytes, currentIndex, sd.getLength());
            currentIndex += sd.getLength();
            ++i3;
        }
        log.debug("RSVP Path Error Message encoding accomplished");
    }

    @Override
    public void decode() throws RSVPProtocolViolationException {
        this.policyData = new LinkedList();
        this.senderDescriptors = new LinkedList();
        int offset = 8;
        while (offset < this.length) {
            int cType;
            int classNum = RSVPObject.getClassNum(this.bytes, offset);
            if (classNum == 1) {
                cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.session = new SessionIPv4(this.bytes, offset);
                    offset += this.session.getLength();
                    continue;
                }
                if (cType == 2) {
                    this.session = new SessionIPv6(this.bytes, offset);
                    offset += this.session.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 4) {
                cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.integrity = new Integrity(this.bytes, offset);
                    offset += this.integrity.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 6) {
                cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    this.errorSpec = new ErrorSpecIPv4(this.bytes, offset);
                    offset += this.errorSpec.getLength();
                    continue;
                }
                if (cType == 2) {
                    this.errorSpec = new ErrorSpecIPv6(this.bytes, offset);
                    offset += this.errorSpec.getLength();
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 14) {
                cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1) {
                    PolicyData pd = new PolicyData(this.bytes, offset);
                    this.policyData.add(pd);
                    System.out.println(" LEEENGO " + pd.getLength() + " offset " + (offset += pd.getLength()) + "length " + this.length);
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            if (classNum == 11) {
                cType = RSVPObject.getcType(this.bytes, offset);
                if (cType == 1 || cType == 2 || cType == 3) {
                    SenderDescriptor sd = new SenderDescriptor();
                    sd.decode(this.bytes, offset);
                    offset += sd.getLength();
                    this.addSenderDescriptor(sd);
                    continue;
                }
                throw new RSVPProtocolViolationException();
            }
            throw new RSVPProtocolViolationException();
        }
    }

    public void addSenderDescriptor(SenderDescriptor senderDescriptor) {
        this.senderDescriptors.add(senderDescriptor);
    }

    public Integrity getIntegrity() {
        return this.integrity;
    }

    public void setIntegrity(Integrity integrity) {
        this.integrity = integrity;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public ErrorSpec getErrorSpec() {
        return this.errorSpec;
    }

    public void setErrorSpec(ErrorSpec errorSpec) {
        this.errorSpec = errorSpec;
    }

    public LinkedList<PolicyData> getPolicyData() {
        return this.policyData;
    }

    public void setPolicyData(LinkedList<PolicyData> policyData) {
        this.policyData = policyData;
    }

    public LinkedList<SenderDescriptor> getSenderDescriptors() {
        return this.senderDescriptors;
    }

    public void setSenderDescriptors(LinkedList<SenderDescriptor> senderDescriptors) {
        this.senderDescriptors = senderDescriptors;
    }
}

