/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.constructs.te;

import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.SEFlowDescriptor;
import es.tid.rsvp.constructs.te.FilterSpecTE;
import es.tid.rsvp.objects.FlowSpec;
import es.tid.rsvp.objects.RSVPObject;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SEFlowDescriptorTE
extends SEFlowDescriptor {
    private FlowSpec flowSpec;
    private LinkedList<FilterSpecTE> filterSpecTEList;
    private static final Logger log = LoggerFactory.getLogger((String)"ROADM");

    public SEFlowDescriptorTE() {
        this.filterSpecTEList = new LinkedList();
        log.debug("FF Flow Descriptor TE Created");
    }

    public SEFlowDescriptorTE(FlowSpec flowSpec, FilterSpecTE filterSpec) throws RSVPProtocolViolationException {
        if (flowSpec != null) {
            this.length += flowSpec.getLength();
        } else {
            log.error("Flow Spec not found, It is mandatory");
            throw new RSVPProtocolViolationException();
        }
        this.flowSpec = flowSpec;
        log.debug("Flow Spec found");
        if (filterSpec != null) {
            this.length += filterSpec.getLength();
        } else {
            log.error("Filter Spec TE not found, It is mandatory");
            throw new RSVPProtocolViolationException();
        }
        this.filterSpecTEList = new LinkedList();
        this.filterSpecTEList.add(filterSpec);
        log.debug("Filter Spec TE found");
        log.debug("SE Flow Descriptor TE Created");
    }

    public void addFilterSpec(FilterSpecTE filterSpec) {
        this.filterSpecTEList.add(filterSpec);
        this.length += filterSpec.getLength();
    }

    @Override
    public void encode() throws RSVPProtocolViolationException {
        log.debug("Starting SE Flow Descriptor TE Encode");
        this.bytes = new byte[this.length];
        int offset = 0;
        if (this.flowSpec != null) {
            this.flowSpec.encode();
            System.arraycopy(this.flowSpec.getBytes(), 0, this.bytes, offset, this.flowSpec.getLength());
            offset += this.flowSpec.getLength();
        } else {
            log.error("Mandatory field Flow Spec not found");
            throw new RSVPProtocolViolationException();
        }
        int fslSize = this.filterSpecTEList.size();
        if (fslSize > 0) {
            int i = 0;
            while (i < fslSize) {
                FilterSpecTE fs = this.filterSpecTEList.get(i);
                fs.encode();
                System.arraycopy(fs.getBytes(), 0, this.bytes, offset, fs.getLength());
                offset += fs.getLength();
                ++i;
            }
        } else {
            log.error("Mandatory field Filter Spec TE not found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Encoding SE Flow Descriptor TE Accomplished");
    }

    @Override
    public void decode(byte[] bytes, int offset) throws RSVPProtocolViolationException {
        FilterSpecTE filterSpecTE;
        log.debug("SE Flow Descriptor Decode");
        int classNum = RSVPObject.getClassNum(bytes, offset);
        int cType = RSVPObject.getcType(bytes, offset);
        int length = 0;
        int bytesLeft = bytes.length - offset;
        if (classNum == 9) {
            if (cType != 2) {
                log.error("Malformed Flow Spec cType field");
                throw new RSVPProtocolViolationException();
            }
            this.flowSpec = new FlowSpec(bytes, offset);
            length += this.flowSpec.getLength();
            bytesLeft -= this.flowSpec.getLength();
        } else {
            log.error("Malformed SE Flow Descriptor, Flow Spec object not found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Sender Template decoded");
        classNum = RSVPObject.getClassNum(bytes, offset += this.flowSpec.getLength());
        cType = RSVPObject.getcType(bytes, offset);
        if (classNum == 10) {
            if (cType == 7) {
                filterSpecTE = new FilterSpecTE();
                filterSpecTE.decode(bytes, offset);
                this.filterSpecTEList.add(filterSpecTE);
                offset += filterSpecTE.getLength();
                length += filterSpecTE.getLength();
                bytesLeft -= filterSpecTE.getLength();
            } else if (cType == 8) {
                filterSpecTE = new FilterSpecTE();
                filterSpecTE.decode(bytes, offset);
                this.filterSpecTEList.add(filterSpecTE);
                offset += filterSpecTE.getLength();
                length += filterSpecTE.getLength();
                bytesLeft -= filterSpecTE.getLength();
            } else {
                log.error("Malformed Filter Spec cType field");
                throw new RSVPProtocolViolationException();
            }
            log.debug("Filter Spec decoded");
        }
        while (bytesLeft > 0) {
            classNum = RSVPObject.getClassNum(bytes, offset);
            cType = RSVPObject.getcType(bytes, offset);
            if (classNum == 10) {
                if (cType == 7) {
                    filterSpecTE = new FilterSpecTE();
                    filterSpecTE.decode(bytes, offset);
                    this.filterSpecTEList.add(filterSpecTE);
                    offset += filterSpecTE.getLength();
                    length += filterSpecTE.getLength();
                    bytesLeft -= filterSpecTE.getLength();
                } else if (cType == 8) {
                    filterSpecTE = new FilterSpecTE();
                    filterSpecTE.decode(bytes, offset);
                    this.filterSpecTEList.add(filterSpecTE);
                    offset += filterSpecTE.getLength();
                    length += filterSpecTE.getLength();
                    bytesLeft -= filterSpecTE.getLength();
                } else {
                    log.error("Malformed Filter Spec cType field");
                    throw new RSVPProtocolViolationException();
                }
                log.debug("Filter Spec decoded");
                continue;
            }
            log.error("Filter Spec expected and not found");
            throw new RSVPProtocolViolationException();
        }
        this.setLength(length);
        log.debug("Decoding FF Flow Descriptor TE Accomplished");
    }

    @Override
    public FlowSpec getFlowSpec() {
        return this.flowSpec;
    }

    @Override
    public void setFlowSpec(FlowSpec flowSpec) {
        this.flowSpec = flowSpec;
    }

    public LinkedList<FilterSpecTE> getFilterSpecTEList() {
        return this.filterSpecTEList;
    }

    public void setFilterSpecTEList(LinkedList<FilterSpecTE> filterSpecTEList) {
        this.filterSpecTEList = filterSpecTEList;
    }
}

