/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.constructs.gmpls;

import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.RSVPConstruct;

public class DWDMWavelengthLabel
extends RSVPConstruct {
    private int grid;
    private int channelSpacing;
    private int identifier;
    private int n;
    private int m;

    @Override
    public void encode() throws RSVPProtocolViolationException {
        if (this.grid == 3) {
            this.setLength(8);
            this.bytes = new byte[this.getLength()];
            this.bytes[0] = (byte)(this.grid << 5 | this.channelSpacing << 1 | this.identifier >>> 8);
            this.bytes[1] = (byte)(this.identifier & 0xFF);
            this.bytes[2] = (byte)(this.n >> 8 & 0xFF);
            this.bytes[3] = (byte)(this.n & 0xFF);
            this.bytes[4] = (byte)(this.m >> 8 & 0xFF);
            this.bytes[5] = (byte)(this.m & 0xFF);
        } else {
            this.setLength(4);
            this.bytes = new byte[this.getLength()];
            this.bytes[0] = (byte)(this.grid << 5 | this.channelSpacing << 1 | this.identifier >>> 8);
            this.bytes[1] = (byte)(this.identifier & 0xFF);
            this.bytes[2] = (byte)(this.n >> 8 & 0xFF);
            this.bytes[3] = (byte)(this.n & 0xFF);
        }
    }

    @Override
    public void decode(byte[] bytes, int offset) throws RSVPProtocolViolationException {
        this.grid = (bytes[offset] & 0xE0) >>> 5;
        this.channelSpacing = (bytes[offset] & 0x1E) >>> 1;
        this.identifier = (bytes[offset] & 1) << 8 | bytes[offset + 1] & 0xFF;
        this.n = (bytes[offset + 2] & 0xFF) << 8 | bytes[offset + 3] & 0xFF;
        if (this.grid == 3) {
            this.m = (bytes[offset + 4] & 0xFF) << 8 | bytes[offset + 5] & 0xFF;
        }
    }

    public int getGrid() {
        return this.grid;
    }

    public void setGrid(int grid) {
        this.grid = grid;
    }

    public int getChannelSpacing() {
        return this.channelSpacing;
    }

    public void setChannelSpacing(int channelSpacing) {
        this.channelSpacing = channelSpacing;
    }

    public int getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(int identifier) {
        this.identifier = identifier;
    }

    public int getN() {
        return this.n;
    }

    public void setN(int n) {
        this.n = n;
    }

    public int getM() {
        return this.m;
    }

    public void setM(int m) {
        this.m = m;
    }

    public String toString() {
        Object ret = "";
        ret = this.grid == 3 ? (String)ret + "Grid " + this.grid + " n:" + Integer.toString(this.n) + " m:" + Integer.toString(this.m) : (String)ret + "Grid " + this.grid + " n:" + Integer.toString(this.n);
        return ret;
    }

    public DWDMWavelengthLabel duplicate() {
        DWDMWavelengthLabel dl = new DWDMWavelengthLabel();
        dl.setGrid(this.grid);
        dl.setChannelSpacing(this.channelSpacing);
        dl.setIdentifier(this.identifier);
        dl.setN(this.n);
        return dl;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.channelSpacing;
        result = 31 * result + this.grid;
        result = 31 * result + this.identifier;
        result = 31 * result + this.m;
        result = 31 * result + this.n;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DWDMWavelengthLabel other = (DWDMWavelengthLabel)obj;
        if (this.channelSpacing != other.channelSpacing) {
            return false;
        }
        if (this.grid != other.grid) {
            return false;
        }
        if (this.identifier != other.identifier) {
            return false;
        }
        if (this.grid == 3 && this.m != other.m) {
            return false;
        }
        return this.n == other.n;
    }
}

