/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.constructs;

import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.ErrorFlowDescriptor;
import es.tid.rsvp.objects.FlowSpec;
import es.tid.rsvp.objects.RSVPObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WFErrorFlowDescriptor
extends ErrorFlowDescriptor {
    private FlowSpec flowSpec;
    private static final Logger log = LoggerFactory.getLogger((String)"ROADM");

    public WFErrorFlowDescriptor() {
        log.debug("WF Flow Descriptor Created");
    }

    public WFErrorFlowDescriptor(FlowSpec flowSpec) throws RSVPProtocolViolationException {
        if (flowSpec != null) {
            this.length += flowSpec.getLength();
        } else {
            log.error("Flow Spec not found, It is mandatory");
            throw new RSVPProtocolViolationException();
        }
        this.flowSpec = flowSpec;
        log.debug("Flow Spec found");
        log.debug("WF Error Flow Descriptor Created");
    }

    @Override
    public void encode() throws RSVPProtocolViolationException {
        log.debug("Starting WF Error Flow Descriptor Encode");
        this.bytes = new byte[this.length];
        int offset = 0;
        this.flowSpec.encode();
        System.arraycopy(this.flowSpec.getBytes(), 0, this.bytes, offset, this.flowSpec.getLength());
        offset += this.flowSpec.getLength();
        log.debug("Encoding WF Flow Descriptor Accomplished");
    }

    @Override
    public void decode(byte[] bytes, int offset) throws RSVPProtocolViolationException {
        log.debug("Starting Error Flow Descriptor Decode");
        int classNum = RSVPObject.getClassNum(bytes, offset);
        int cType = RSVPObject.getcType(bytes, offset);
        int length = 0;
        int bytesLeft = bytes.length - offset;
        if (classNum == 9) {
            if (cType != 2) {
                log.error("Malformed Flow Spec cType field");
                throw new RSVPProtocolViolationException();
            }
            this.flowSpec = new FlowSpec(bytes, offset);
            offset += this.flowSpec.getLength();
            bytesLeft -= this.flowSpec.getLength();
        } else {
            log.error("Flow Spec not found, It is mandatory");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Sender Template decoded");
        this.setLength(length += this.flowSpec.getLength());
        log.debug("Decoding WF Flow Descriptor Accomplished");
    }

    public FlowSpec getFlowSpec() {
        return this.flowSpec;
    }

    public void setFlowSpec(FlowSpec flowSpec) {
        this.flowSpec = flowSpec;
    }
}

