/*
 * Decompiled with CFR 0.152.
 */
package es.tid.rsvp.constructs;

import es.tid.rsvp.RSVPProtocolViolationException;
import es.tid.rsvp.constructs.ErrorFlowDescriptor;
import es.tid.rsvp.objects.FilterSpec;
import es.tid.rsvp.objects.FilterSpecIPv4;
import es.tid.rsvp.objects.FilterSpecIPv6;
import es.tid.rsvp.objects.FlowLabelFilterSpecIPv6;
import es.tid.rsvp.objects.FlowSpec;
import es.tid.rsvp.objects.RSVPObject;
import java.util.LinkedList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SEErrorFlowDescriptor
extends ErrorFlowDescriptor {
    private FlowSpec flowSpec;
    private LinkedList<FilterSpec> filterSpecList;
    private static final Logger log = LoggerFactory.getLogger((String)"ROADM");

    public SEErrorFlowDescriptor() {
        this.filterSpecList = new LinkedList();
        log.debug("FF Error Flow Descriptor Created");
    }

    public SEErrorFlowDescriptor(FlowSpec flowSpec, FilterSpec filterSpec) throws RSVPProtocolViolationException {
        if (flowSpec != null) {
            this.length += flowSpec.getLength();
        } else {
            log.error("Flow Spec not found, It is mandatory");
            throw new RSVPProtocolViolationException();
        }
        this.flowSpec = flowSpec;
        log.debug("Flow Spec found");
        if (filterSpec != null) {
            this.length += filterSpec.getLength();
        } else {
            log.error("Filter Spec not found, It is mandatory");
            throw new RSVPProtocolViolationException();
        }
        this.filterSpecList = new LinkedList();
        this.filterSpecList.add(filterSpec);
        log.debug("Filter Spec found");
        log.debug("SE Error Flow Descriptor Created");
    }

    public void addFilterSpec(FilterSpec filterSpec) {
        this.filterSpecList.add(filterSpec);
        this.length += filterSpec.getLength();
    }

    @Override
    public void encode() throws RSVPProtocolViolationException {
        log.debug("Starting SE Error Flow Descriptor Encode");
        this.bytes = new byte[this.length];
        int offset = 0;
        if (this.flowSpec != null) {
            this.flowSpec.encode();
            System.arraycopy(this.flowSpec.getBytes(), 0, this.bytes, offset, this.flowSpec.getLength());
            offset += this.flowSpec.getLength();
        } else {
            log.error("Mandatory field Flow Spec not found");
            throw new RSVPProtocolViolationException();
        }
        int fslSize = this.filterSpecList.size();
        if (fslSize > 0) {
            int i = 0;
            while (i < fslSize) {
                FilterSpec fs = this.filterSpecList.get(i);
                fs.encode();
                System.arraycopy(fs.getBytes(), 0, this.bytes, offset, fs.getLength());
                offset += fs.getLength();
                ++i;
            }
        } else {
            log.error("Mandatory field Filter Spec not found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Encoding SE Error Flow Descriptor Accomplished");
    }

    @Override
    public void decode(byte[] bytes, int offset) throws RSVPProtocolViolationException {
        FilterSpec filterSpec;
        log.debug("SE Flow Descriptor Decode");
        int classNum = RSVPObject.getClassNum(bytes, offset);
        int cType = RSVPObject.getcType(bytes, offset);
        int length = 0;
        int bytesLeft = bytes.length - offset;
        if (classNum == 9) {
            if (cType != 2) {
                log.error("Malformed Flow Spec cType field");
                throw new RSVPProtocolViolationException();
            }
            this.flowSpec = new FlowSpec(bytes, offset);
            length += this.flowSpec.getLength();
            bytesLeft -= this.flowSpec.getLength();
        } else {
            log.error("Malformed SE Flow Descriptor, Flow Spec object not found");
            throw new RSVPProtocolViolationException();
        }
        log.debug("Sender Template decoded");
        classNum = RSVPObject.getClassNum(bytes, offset += this.flowSpec.getLength());
        cType = RSVPObject.getcType(bytes, offset);
        if (classNum == 10) {
            if (cType == 1) {
                filterSpec = new FilterSpecIPv4(bytes, offset);
                this.filterSpecList.add(filterSpec);
                offset += filterSpec.getLength();
                length += filterSpec.getLength();
                bytesLeft -= filterSpec.getLength();
            } else if (cType == 2) {
                filterSpec = new FilterSpecIPv6(bytes, offset);
                this.filterSpecList.add(filterSpec);
                offset += filterSpec.getLength();
                length += filterSpec.getLength();
                bytesLeft -= filterSpec.getLength();
            } else if (cType == 3) {
                filterSpec = new FlowLabelFilterSpecIPv6(bytes, offset);
                this.filterSpecList.add(filterSpec);
                offset += filterSpec.getLength();
                length += filterSpec.getLength();
                bytesLeft -= filterSpec.getLength();
            } else {
                log.error("Malformed Filter Spec cType field");
                throw new RSVPProtocolViolationException();
            }
            log.debug("Filter Spec decoded");
        }
        while (bytesLeft > 0) {
            classNum = RSVPObject.getClassNum(bytes, offset);
            cType = RSVPObject.getcType(bytes, offset);
            if (classNum == 10) {
                if (cType == 1) {
                    filterSpec = new FilterSpecIPv4(bytes, offset);
                    this.filterSpecList.add(filterSpec);
                    offset += filterSpec.getLength();
                    length += filterSpec.getLength();
                    bytesLeft -= filterSpec.getLength();
                } else if (cType == 2) {
                    filterSpec = new FilterSpecIPv6(bytes, offset);
                    this.filterSpecList.add(filterSpec);
                    offset += filterSpec.getLength();
                    length += filterSpec.getLength();
                    bytesLeft -= filterSpec.getLength();
                } else if (cType == 3) {
                    filterSpec = new FlowLabelFilterSpecIPv6(bytes, offset);
                    this.filterSpecList.add(filterSpec);
                    offset += filterSpec.getLength();
                    length += filterSpec.getLength();
                    bytesLeft -= filterSpec.getLength();
                } else {
                    log.error("Malformed Filter Spec cType field");
                    throw new RSVPProtocolViolationException();
                }
                log.debug("Filter Spec decoded");
                continue;
            }
            log.error("Filter Spec expected and not found");
            throw new RSVPProtocolViolationException();
        }
        this.setLength(length);
        log.debug("Decoding FF Error Flow Descriptor Accomplished");
    }

    public FlowSpec getFlowSpec() {
        return this.flowSpec;
    }

    public void setFlowSpec(FlowSpec flowSpec) {
        this.flowSpec = flowSpec;
    }

    public LinkedList<FilterSpec> getFilterSpecList() {
        return this.filterSpecList;
    }

    public void setFilterSpecList(LinkedList<FilterSpec> filterSpecList) {
        this.filterSpecList = filterSpecList;
    }
}

