/*
 * Decompiled with CFR 0.152.
 */
package es.tid.protocol.commons;

import java.nio.ByteBuffer;
import java.util.BitSet;

public class ByteHandler {
    public static int easyCopy(int begin, int end, byte ... bytes) {
        int i;
        int dest = 0;
        if (begin >= 0 && begin <= end) {
            int cfr_ignored_0 = bytes.length;
        }
        byte[] bCleared = new byte[bytes.length];
        int i2 = 0;
        while (i2 < bytes.length) {
            bCleared[i2] = i2 < begin / 8 || i2 > end / 8 ? (byte)0 : bytes[i2];
            ++i2;
        }
        int forClearing = 0;
        if (begin / 8 == end / 8) {
            i = 0;
            while (i < end - begin + 1) {
                forClearing = (byte)((0xFF & forClearing) << 1 | 1);
                ++i;
            }
            forClearing = (byte)((0xFF & forClearing) << 8 - end % 8 - 1);
            bCleared[end / 8] = (byte)(0xFF & bCleared[end / 8] & (0xFF & forClearing));
        } else {
            i = 0;
            while (i < 8 - begin % 8) {
                forClearing = (byte)((0xFF & forClearing) << 1 | 1);
                ++i;
            }
            bCleared[begin / 8] = (byte)(0xFF & bCleared[begin / 8] & (0xFF & forClearing));
            forClearing = 0;
            i = 0;
            while (i < end % 8 + 1) {
                forClearing = (byte)((0xFF & forClearing) << 1 | 1);
                ++i;
            }
            forClearing = (byte)(forClearing << 8 - end % 8 - 1);
            bCleared[end / 8] = (byte)(0xFF & (0xFF & bCleared[end / 8] & (0xFF & forClearing)));
        }
        if (begin / 8 == end / 8) {
            dest = 0xFF & (0xFF & bCleared[end / 8]) >> 8 - end % 8 - 1;
        } else {
            dest = bCleared[begin / 8] & 0xFF;
            i = begin / 8 + 1;
            while (i < end / 8) {
                dest = dest << 8 | 0xFF & bCleared[i];
                ++i;
            }
            dest = dest << end % 8 + 1 | 0xFF & (0xFF & bCleared[end / 8]) >> 8 - end % 8 - 1;
        }
        return dest;
    }

    public static long easyCopyL(int begin, int end, byte ... bytes) {
        int i;
        long dest = 0L;
        if (begin < 0 || begin > end || bytes.length * 8 <= end || end - begin > 63) {
            return -1L;
        }
        byte[] bCleared = new byte[bytes.length];
        int i2 = 0;
        while (i2 < bytes.length) {
            bCleared[i2] = i2 < begin / 8 || i2 > end / 8 ? (byte)0 : bytes[i2];
            ++i2;
        }
        int forClearing = 0;
        if (begin / 8 == end / 8) {
            i = 0;
            while (i < end - begin + 1) {
                forClearing = (byte)((0xFF & forClearing) << 1 | 1);
                ++i;
            }
            forClearing = (byte)((0xFF & forClearing) << 8 - end - 1);
            bCleared[end / 8] = (byte)(0xFF & bCleared[end / 8] & (0xFF & forClearing));
        } else {
            i = 0;
            while (i < 8 - begin % 8) {
                forClearing = (byte)((0xFF & forClearing) << 1 | 1);
                ++i;
            }
            bCleared[begin / 8] = (byte)(0xFF & bCleared[begin / 8] & (0xFF & forClearing));
            forClearing = 0;
            i = 0;
            while (i < end % 8 + 1) {
                forClearing = (byte)((0xFF & forClearing) << 1 | 1);
                ++i;
            }
            forClearing = (byte)(forClearing << 8 - end % 8 - 1);
            bCleared[end / 8] = (byte)(0xFF & (0xFF & bCleared[end / 8] & (0xFF & forClearing)));
        }
        if (begin / 8 == end / 8) {
            dest = 0xFF & (0xFF & bCleared[end / 8]) >> 8 - end % 8 - 1;
        } else {
            dest = bCleared[begin / 8] & 0xFF;
            i = begin / 8 + 1;
            while (i < end / 8) {
                dest = dest << 8 | (long)(0xFF & bCleared[i]);
                ++i;
            }
            dest = dest << end % 8 + 1 | (long)(0xFF & (0xFF & bCleared[end / 8]) >> 8 - end % 8 - 1);
        }
        return dest;
    }

    public static byte[] toByteArray(BitSet bits, int length) {
        byte[] bytes = new byte[(length + 7) / 8];
        int i = 0;
        while (i < length) {
            if (bits.get(i)) {
                int n = i / 8;
                bytes[n] = (byte)(bytes[n] | 1 << i % 8);
            }
            ++i;
        }
        return bytes;
    }

    private static BitSet myBitSetValueOf(byte[] bs) {
        BitSet bS = new BitSet();
        int n = 0;
        while (n < 8 * bs.length) {
            bS.set(n, (bs[n / 8] & 1 << n % 8) != 0);
            ++n;
        }
        return bS;
    }

    public static void bufferToBuffer(int begS, byte[] source, int begD, byte[] dest, int length) {
        BitSet sourceSet = ByteHandler.myBitSetValueOf(source);
        BitSet destSet = ByteHandler.myBitSetValueOf(dest);
        int i = begS;
        int j = begD;
        while (i < begS + length) {
            if (sourceSet.get(i - i % 8 + (8 - i % 8 - 1))) {
                destSet.set(j - j % 8 + (8 - j % 8 - 1));
            } else {
                destSet.clear(j - j % 8 + (8 - j % 8 - 1));
            }
            ++i;
            ++j;
        }
        byte[] intSourceSet = ByteHandler.toByteArray(sourceSet, source.length * 8);
        byte[] intDestSet = ByteHandler.toByteArray(destSet, dest.length * 8);
        int i2 = 0;
        while (i2 < source.length) {
            source[i2] = intSourceSet[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < dest.length) {
            dest[i2] = intDestSet[i2];
            ++i2;
        }
    }

    public static void IntToBuffer(int begS, int begD, int length, int value, byte[] dest) {
        ByteHandler.bufferToBuffer(begS, ByteBuffer.allocate(4).putInt(value).array(), begD, dest, length);
    }

    public static void LongToBuffer(int begS, int begD, int length, long value, byte[] dest) {
        ByteHandler.bufferToBuffer(begS, ByteBuffer.allocate(8).putLong(value).array(), begD, dest, length);
    }

    public static void BoolToBuffer(int bitPos, boolean value, byte[] dest) {
        if (value) {
            ByteHandler.IntToBuffer(0, bitPos, 1, -1, dest);
        } else {
            ByteHandler.IntToBuffer(0, bitPos, 1, 0, dest);
        }
    }

    public static String ByteMACToString(byte[] mac) {
        StringBuilder sb = new StringBuilder(mac.length * 3);
        byte[] byArray = mac;
        int n = mac.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (sb.length() > 0) {
                sb.append(':');
            }
            sb.append(String.format("%02x", b));
            ++n2;
        }
        return sb.toString();
    }

    public static String ByteDataPathToString(byte[] mac) {
        StringBuilder sb = new StringBuilder(16);
        byte[] byArray = mac;
        int n = mac.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            if (sb.length() > 0) {
                sb.append(':');
            }
            sb.append(String.format("%02x", b));
            ++n2;
        }
        return sb.toString();
    }

    public static byte[] MACFormatStringtoByteArray(String macAddress) {
        String[] macAddressParts = macAddress.split(":");
        byte[] macAddressBytes = new byte[macAddressParts.length];
        int i = 0;
        while (i < macAddressParts.length) {
            Integer hex = Integer.parseInt(macAddressParts[i], 16);
            macAddressBytes[i] = hex.byteValue();
            ++i;
        }
        return macAddressBytes;
    }

    public static byte[] MACStringtoByteArray(String macAddress) {
        String[] macAddressParts = macAddress.split(":");
        byte[] macAddressBytes = new byte[6];
        int i = 0;
        while (i < 6) {
            Integer hex = Integer.parseInt(macAddressParts[i], 16);
            macAddressBytes[i] = hex.byteValue();
            ++i;
        }
        return macAddressBytes;
    }

    public static byte[] DataPathFormatStringtoByteArray(String DataPath) {
        String[] DataPathParts = DataPath.split(":");
        byte[] macAddressBytes = new byte[DataPathParts.length];
        int i = 0;
        while (i < DataPathParts.length) {
            Integer hex = Integer.parseInt(DataPathParts[i], 16);
            macAddressBytes[i] = hex.byteValue();
            ++i;
        }
        return macAddressBytes;
    }

    public static byte[] DataPathStringtoByteArray(String DataPath) {
        String[] DataPathParts = DataPath.split(":");
        byte[] DataPathBytes = new byte[6];
        int i = 0;
        while (i < 8) {
            Integer hex = Integer.parseInt(DataPathParts[i], 16);
            DataPathBytes[i] = hex.byteValue();
            ++i;
        }
        return DataPathBytes;
    }

    public static void encode1Float(float number, byte[] bytes, int offset) {
        int number_int = Float.floatToIntBits(number);
        bytes[offset] = (byte)(number_int >>> 24);
        bytes[++offset] = (byte)(number_int >> 16 & 0xFF);
        bytes[++offset] = (byte)(number_int >> 8 & 0xFF);
        bytes[++offset] = (byte)(number_int & 0xFF);
    }

    public static void encode4bytesLong(long number, byte[] bytes, int offset) {
        bytes[offset] = (byte)(number >> 24 & 0xFFL);
        bytes[offset + 1] = (byte)(number >> 16 & 0xFFL);
        bytes[offset + 2] = (byte)(number >> 8 & 0xFFL);
        bytes[offset + 3] = (byte)(number & 0xFFL);
    }

    public static void encode1byteInteger(int number, byte[] bytes, int offset) {
        bytes[offset] = (byte)(number & 0xFF);
    }

    public static void encode2bytesInteger(int number, byte[] bytes, int offset) {
        bytes[offset] = (byte)(number >> 8 & 0xFF);
        bytes[offset + 1] = (byte)(number & 0xFF);
    }

    public static void encode3bytesInteger(int number, byte[] bytes, int offset) {
        bytes[offset] = (byte)(number >> 16 & 0xFF);
        bytes[offset + 1] = (byte)(number >> 8 & 0xFF);
        bytes[offset + 2] = (byte)(number & 0xFF);
    }

    public static float decode1Float(byte[] bytes, int offset) {
        float number = 0.0f;
        int number_int = 0;
        int k = 0;
        while (k < 4) {
            number_int = number_int << 8 | bytes[k + offset] & 0xFF;
            ++k;
        }
        number = Float.intBitsToFloat(number_int);
        return number;
    }

    public static long decode4bytesLong(byte[] bytes, int offset) {
        long number = 0L;
        number = ((long)bytes[offset] & 0xFFL) << 24 | ((long)bytes[offset + 1] & 0xFFL) << 16 | ((long)bytes[offset + 2] & 0xFFL) << 8 | (long)bytes[offset + 3] & 0xFFL;
        return number;
    }

    public static int decode2bytesInteger(byte[] bytes, int offset) {
        int number = 0;
        number = (bytes[offset] & 0xFF) << 8 | bytes[offset + 1] & 0xFF;
        return number;
    }

    public static int decode3bytesInteger(byte[] bytes, int offset) {
        int number = 0;
        number = (bytes[offset] & 0xFF) << 16 | (bytes[offset + 1] & 0xFF) << 8 | bytes[offset + 2] & 0xFF;
        return number;
    }

    public static int decode1byteInteger(byte[] bytes, int offset) {
        int number = 0;
        number = bytes[offset] & 0xFF;
        return number;
    }
}

