/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects.tlvs;

import es.tid.pce.pcep.objects.tlvs.PCEPTLV;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public class UnnumberedEndpointTLV
extends PCEPTLV {
    public Inet4Address IPv4address;
    private long ifID;

    public UnnumberedEndpointTLV() {
        this.setTLVType(41);
    }

    public UnnumberedEndpointTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.setTLVValueLength(8);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        System.arraycopy(this.IPv4address.getAddress(), 0, this.tlv_bytes, 4, 4);
        this.getTlv_bytes()[8] = (byte)(this.ifID >>> 24);
        this.getTlv_bytes()[9] = (byte)(this.ifID >>> 16 & 0xFFL);
        this.getTlv_bytes()[10] = (byte)(this.ifID >>> 8 & 0xFFL);
        this.getTlv_bytes()[11] = (byte)(this.ifID & 0xFFL);
    }

    public void decode() {
        byte[] ip = new byte[4];
        System.arraycopy(this.tlv_bytes, 4, ip, 0, 4);
        try {
            this.IPv4address = (Inet4Address)Inet4Address.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        int offset = 8;
        this.ifID = 0L;
        int k = 0;
        while (k < 4) {
            this.ifID = this.ifID << 8 | (long)(this.getTlv_bytes()[k + offset] & 0xFF);
            ++k;
        }
    }

    public Inet4Address getIPv4address() {
        return this.IPv4address;
    }

    public void setIPv4address(Inet4Address iPv4address) {
        this.IPv4address = iPv4address;
    }

    public long getIfID() {
        return this.ifID;
    }

    public void setIfID(long ifID) {
        this.ifID = ifID;
    }

    public String toString() {
        if (this.IPv4address != null) {
            return this.IPv4address.getHostAddress() + ":" + this.ifID;
        }
        return "";
    }
}

