/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects.tlvs;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;
import java.util.Objects;

public class SRPolicyName
extends PCEPTLV {
    private String policyName;

    public SRPolicyName() {
        this.TLVType = 56;
    }

    public SRPolicyName(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    public String getPolicyName() {
        return this.policyName;
    }

    public void setPolicyName(String policyName) {
        this.policyName = policyName;
    }

    @Override
    public void encode() {
        log.debug("Encoding SR Policy TLV");
        int length = 0;
        length = this.policyName.length() / 4;
        System.out.println("POLICY NAME: " + this.policyName);
        System.out.println("LONGITUD 1:  " + length);
        if (this.policyName.length() % 4 != 0) {
            ++length;
        }
        System.out.println("LONGITUD 2:  " + (length *= 4));
        this.setTLVValueLength(length);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        System.arraycopy(this.policyName.getBytes(), 0, this.tlv_bytes, offset, this.policyName.length());
    }

    public void decode() throws MalformedPCEPObjectException {
        log.debug("Decoding SR Policy Name TLV");
        byte[] policyNamePaso = new byte[this.getTLVValueLength()];
        int offset = 4;
        if (this.getTLVValueLength() == 0) {
            throw new MalformedPCEPObjectException();
        }
        try {
            System.arraycopy(this.tlv_bytes, offset, policyNamePaso, 0, this.getTLVValueLength());
            this.policyName = new String(policyNamePaso);
            log.debug("Sended name : " + this.policyName);
        }
        catch (Exception e) {
            log.error("Exception occurred, Possibly TLV size is not what expected");
            throw new MalformedPCEPObjectException();
        }
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.policyName);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SRPolicyName other = (SRPolicyName)obj;
        return Objects.equals(this.policyName, other.policyName);
    }

    public String toString() {
        return "SRPolicyName [policyName=" + this.policyName + "]";
    }
}

