/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects.tlvs;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;
import es.tid.protocol.commons.ByteHandler;
import java.net.Inet4Address;
import java.util.Objects;

public class SRPolicyCandidatePathIdentifiersTLV
extends PCEPTLV {
    private int protocol;
    private long originatorASN;
    private Inet4Address originatorAddress;
    private long discriminator;

    public SRPolicyCandidatePathIdentifiersTLV() {
        this.TLVType = 57;
    }

    public SRPolicyCandidatePathIdentifiersTLV(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    public int getProtocol() {
        return this.protocol;
    }

    public void setProtocol(int protocol) {
        this.protocol = protocol;
    }

    public long getOriginatorASN() {
        return this.originatorASN;
    }

    public void setOriginatorASN(long originatorASN) {
        this.originatorASN = originatorASN;
    }

    public Inet4Address getOriginatorAddress() {
        return this.originatorAddress;
    }

    public void setOriginatorAddress(Inet4Address originatorAddress) {
        this.originatorAddress = originatorAddress;
    }

    public long getDiscriminator() {
        return this.discriminator;
    }

    public void setDiscriminator(long discriminator) {
        this.discriminator = discriminator;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.discriminator, this.originatorASN, this.originatorAddress, this.protocol);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SRPolicyCandidatePathIdentifiersTLV other = (SRPolicyCandidatePathIdentifiersTLV)obj;
        return this.discriminator == other.discriminator && this.originatorASN == other.originatorASN && Objects.equals(this.originatorAddress, other.originatorAddress) && this.protocol == other.protocol;
    }

    public String toString() {
        return "SRPolicyCandidatePathIdentifiersTLV [protocol=" + this.protocol + ", originatorASN=" + this.originatorASN + ", originatorAddress=" + String.valueOf(this.originatorAddress) + ", discriminator=" + this.discriminator + "]";
    }

    @Override
    public void encode() {
        this.setTLVValueLength(32);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        int reserved = 0;
        ByteHandler.encode1byteInteger(this.protocol, this.tlv_bytes, offset);
        ByteHandler.encode3bytesInteger(reserved, this.tlv_bytes, ++offset);
        ByteHandler.encode4bytesLong(this.originatorASN, this.tlv_bytes, offset += 3);
        ByteHandler.encode4bytesLong(reserved, this.tlv_bytes, offset += 4);
        ByteHandler.encode4bytesLong(reserved, this.tlv_bytes, offset += 4);
        ByteHandler.encode4bytesLong(reserved, this.tlv_bytes, offset += 4);
        System.arraycopy(this.originatorAddress.getAddress(), 0, this.tlv_bytes, offset += 4, 4);
        ByteHandler.encode4bytesLong(this.discriminator, this.tlv_bytes, offset += 4);
    }

    public void decode() throws MalformedPCEPObjectException {
        log.debug("Decoding SRPolicyCandidatePathIdentifiersTLV TLV");
        int offset = 4;
        if (this.getTLVValueLength() == 0) {
            throw new MalformedPCEPObjectException();
        }
        try {
            this.protocol = ByteHandler.decode1byteInteger(this.tlv_bytes, offset);
            this.originatorASN = ByteHandler.decode4bytesLong(this.tlv_bytes, offset += 4);
            byte[] ip = new byte[4];
            System.arraycopy(this.tlv_bytes, offset += 16, ip, 0, 4);
            this.originatorAddress = (Inet4Address)Inet4Address.getByAddress(ip);
            this.discriminator = ByteHandler.decode4bytesLong(this.tlv_bytes, offset += 4);
        }
        catch (Exception e) {
            log.error("Exception occurred, Possibly TLV size is not what expected");
            throw new MalformedPCEPObjectException();
        }
    }
}

