/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects.tlvs;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public class RequestInfoTLV
extends PCEPTLV {
    private Inet4Address IPv4Address;
    private long requestId;

    public RequestInfoTLV() {
        this.TLVType = 3070;
    }

    public RequestInfoTLV(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.setTLVValueLength(8);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        System.arraycopy(this.IPv4Address.getAddress(), 0, this.tlv_bytes, 4, 4);
        this.tlv_bytes[8] = (byte)(this.requestId >> 24 & 0xFFL);
        this.tlv_bytes[9] = (byte)(this.requestId >> 16 & 0xFFL);
        this.tlv_bytes[10] = (byte)(this.requestId >> 8 & 0xFFL);
        this.tlv_bytes[11] = (byte)(this.requestId & 0xFFL);
    }

    public void decode() throws MalformedPCEPObjectException {
        log.debug("Decoding RequestInfo TLV");
        byte[] ip = new byte[4];
        System.arraycopy(this.tlv_bytes, 4, ip, 0, 4);
        try {
            this.IPv4Address = (Inet4Address)Inet4Address.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.requestId = ((long)this.tlv_bytes[8] & 0xFFL) << 24 | ((long)this.tlv_bytes[9] & 0xFFL) << 16 | ((long)this.tlv_bytes[10] & 0xFFL) << 8 | (long)this.tlv_bytes[11] & 0xFFL;
    }

    public Inet4Address getIPv4Address() {
        return this.IPv4Address;
    }

    public void setIPv4Address(Inet4Address iPv4Address) {
        this.IPv4Address = iPv4Address;
    }

    public long getRequestId() {
        return this.requestId;
    }

    public void setRequestId(long requestId) {
        this.requestId = requestId;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.IPv4Address == null ? 0 : this.IPv4Address.hashCode());
        result = 31 * result + (int)(this.requestId ^ this.requestId >>> 32);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RequestInfoTLV other = (RequestInfoTLV)obj;
        if (this.IPv4Address == null ? other.IPv4Address != null : !this.IPv4Address.equals(other.IPv4Address)) {
            return false;
        }
        return this.requestId == other.requestId;
    }
}

