/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects.tlvs;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;
import es.tid.rsvp.objects.subobjects.ASNumberEROSubobject;
import es.tid.rsvp.objects.subobjects.EROSubobject;
import es.tid.rsvp.objects.subobjects.IPv4prefixEROSubobject;
import es.tid.rsvp.objects.subobjects.IPv6prefixEROSubobject;
import es.tid.rsvp.objects.subobjects.UnnumberIfIDEROSubobject;
import java.util.LinkedList;

public class ReachabilityTLV
extends PCEPTLV {
    public LinkedList<EROSubobject> EROSubobjectList;

    public ReachabilityTLV() {
        this.TLVType = 32777;
        this.EROSubobjectList = new LinkedList();
    }

    public ReachabilityTLV(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.EROSubobjectList = new LinkedList();
        this.decode();
    }

    @Override
    public void encode() {
        int len = 0;
        int k = 0;
        while (k < this.EROSubobjectList.size()) {
            this.EROSubobjectList.get(k).encode();
            len += this.EROSubobjectList.get(k).getErosolength();
            ++k;
        }
        this.setTLVValueLength(len);
        this.tlv_bytes = new byte[this.TotalTLVLength];
        this.encodeHeader();
        int pos = 4;
        int k2 = 0;
        while (k2 < this.EROSubobjectList.size()) {
            System.arraycopy(this.EROSubobjectList.get(k2).getSubobject_bytes(), 0, this.tlv_bytes, pos, this.EROSubobjectList.get(k2).getErosolength());
            pos += this.EROSubobjectList.get(k2).getErosolength();
            ++k2;
        }
    }

    public void decode() throws MalformedPCEPObjectException {
        int offset = 4;
        log.debug("Decoding Reachability TLV");
        boolean fin = false;
        if (this.TLVValueLength == 0) {
            fin = true;
        }
        try {
            while (!fin) {
                int subojectclass = EROSubobject.getType(this.tlv_bytes, offset);
                int subojectlength = EROSubobject.getLength(this.tlv_bytes, offset);
                switch (subojectclass) {
                    case 1: {
                        IPv4prefixEROSubobject sobjt4 = new IPv4prefixEROSubobject(this.tlv_bytes, offset);
                        log.debug("IPv4 prefix found:" + String.valueOf(sobjt4));
                        this.addEROSubobject(sobjt4);
                        break;
                    }
                    case 2: {
                        IPv6prefixEROSubobject sobjt6 = new IPv6prefixEROSubobject(this.tlv_bytes, offset);
                        log.debug("IPv6 prefix found:" + String.valueOf(sobjt6));
                        this.addEROSubobject(sobjt6);
                        break;
                    }
                    case 32: {
                        ASNumberEROSubobject sobjas = new ASNumberEROSubobject(this.tlv_bytes, offset);
                        log.debug("AS Number found found:" + String.valueOf(sobjas));
                        this.addEROSubobject(sobjas);
                        break;
                    }
                    case 4: {
                        UnnumberIfIDEROSubobject subun = new UnnumberIfIDEROSubobject(this.tlv_bytes, offset);
                        log.debug("Unnumbered If Id found:" + String.valueOf(subun));
                        this.addEROSubobject(subun);
                        break;
                    }
                    default: {
                        log.debug("ERO Subobject Unknown");
                    }
                }
                if ((offset += subojectlength) < this.TLVValueLength) continue;
                log.debug("No more subobjects in the Reachability TLV");
                fin = true;
            }
        }
        catch (Exception e) {
            throw new MalformedPCEPObjectException();
        }
    }

    public void addEROSubobject(EROSubobject eroso) {
        this.EROSubobjectList.add(eroso);
    }

    public LinkedList<EROSubobject> getEROSubobjectList() {
        return this.EROSubobjectList;
    }

    public void setEROSubobjectList(LinkedList<EROSubobject> eROSubobjectList) {
        this.EROSubobjectList = eROSubobjectList;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.EROSubobjectList == null ? 0 : this.EROSubobjectList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReachabilityTLV other = (ReachabilityTLV)obj;
        return !(this.EROSubobjectList == null ? other.EROSubobjectList != null : !this.EROSubobjectList.equals(other.EROSubobjectList));
    }
}

