/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects.tlvs;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;
import es.tid.protocol.commons.ByteHandler;

public class PathSetupTLV
extends PCEPTLV {
    public static final int DEFAULT = 0;
    public static final int SR = 1;
    protected int PST;

    public PathSetupTLV() {
        this.TLVType = 28;
    }

    public PathSetupTLV(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.TotalTLVLength = 8;
        this.TLVValueLength = 4;
        int length = 4;
        this.setTLVValueLength(length);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int Zero = 0;
        int offset = 4;
        log.debug("Encoding SRCapabilityTLV: PST =" + this.PST + " bytes: " + this.getTotalTLVLength());
        ByteHandler.IntToBuffer(0, offset * 8, 32, Zero, this.tlv_bytes);
        byte[] aux = new byte[]{(byte)(this.PST & 0xFF)};
        System.arraycopy(aux, 0, this.tlv_bytes, 7, 1);
        log.debug("finished Encoding PathSetupTLV: PST =" + this.PST);
    }

    public void decode() {
        log.debug("Decoding PathSetupTLV");
        int offset = 7;
        byte[] aux = new byte[1];
        System.arraycopy(this.tlv_bytes, offset, aux, 0, 1);
        this.PST = aux[0] & 0xFF;
        log.debug("PST decoded, value: " + this.PST);
    }

    public int getPST() {
        return this.PST;
    }

    public void setPST(int PST) {
        this.PST = PST;
    }

    public boolean isSR() {
        return this.PST == 1;
    }
}

