/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects.tlvs;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;
import es.tid.pce.pcep.objects.tlvs.SRCapabilityTLV;
import es.tid.protocol.commons.ByteHandler;
import java.util.LinkedList;

public class PathSetupCapabilityTLV
extends PCEPTLV {
    private LinkedList<Integer> pathSetupTypes;
    private SRCapabilityTLV srCapabilitySubTLV;

    public PathSetupCapabilityTLV() {
        this.TLVType = 34;
        this.pathSetupTypes = new LinkedList();
    }

    public PathSetupCapabilityTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.pathSetupTypes = new LinkedList();
        this.decode();
    }

    @Override
    public void encode() {
        int numTypes = this.pathSetupTypes.size();
        int len = 4 + numTypes;
        if (len % 4 != 0) {
            len = len + 4 - len % 4;
        }
        if (this.srCapabilitySubTLV != null) {
            this.srCapabilitySubTLV.encode();
            len += this.srCapabilitySubTLV.getTotalTLVLength();
        }
        this.setTLVValueLength(len);
        this.setTlv_bytes(new byte[this.getTotalTLVLength()]);
        this.encodeHeader();
        int offset = 4;
        this.getTlv_bytes()[offset] = 0;
        this.getTlv_bytes()[offset + 1] = 0;
        this.getTlv_bytes()[offset + 2] = 0;
        ByteHandler.encode1byteInteger(numTypes, this.getTlv_bytes(), offset += 3);
        ++offset;
        int i = 0;
        while (i < this.pathSetupTypes.size()) {
            ByteHandler.encode1byteInteger(this.pathSetupTypes.get(i), this.getTlv_bytes(), offset);
            ++offset;
            ++i;
        }
        int old_offset = offset;
        if (offset % 4 != 0) {
            offset = offset + 4 - offset % 4;
        }
        int i2 = old_offset;
        while (i2 < offset) {
            this.getTlv_bytes()[i2] = 0;
            ++i2;
        }
        if (this.srCapabilitySubTLV != null) {
            System.arraycopy(this.srCapabilitySubTLV.getTlv_bytes(), 0, this.getTlv_bytes(), offset, this.srCapabilitySubTLV.getTotalTLVLength());
        }
    }

    public void decode() {
        int offset = 7;
        int numTypes = ByteHandler.decode1byteInteger(this.getTlv_bytes(), offset);
        ++offset;
        int i = 0;
        while (i < numTypes) {
            int pathSetupType = ByteHandler.decode1byteInteger(this.getTlv_bytes(), offset);
            this.pathSetupTypes.add(pathSetupType);
            ++offset;
            ++i;
        }
        if (offset % 4 != 0) {
            offset = offset + 4 - offset % 4;
        }
        boolean fin = false;
        if (offset >= this.getTotalTLVLength()) {
            fin = true;
        }
        while (!fin) {
            int tlvtype = PCEPTLV.getType(this.getTlv_bytes(), offset);
            int tlvlength = PCEPTLV.getTotalTLVLength(this.getTlv_bytes(), offset);
            switch (tlvtype) {
                case 26: {
                    try {
                        this.srCapabilitySubTLV = new SRCapabilityTLV(this.getTlv_bytes(), offset);
                    }
                    catch (MalformedPCEPObjectException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                default: {
                    log.debug("UNKNOWN TLV found");
                }
            }
            if ((offset += tlvlength) < this.getTotalTLVLength()) continue;
            fin = true;
        }
    }

    public LinkedList<Integer> getPathSetupTypes() {
        return this.pathSetupTypes;
    }

    public void setPathSetupTypes(LinkedList<Integer> pathSetupTypes) {
        this.pathSetupTypes = pathSetupTypes;
    }

    public SRCapabilityTLV getSrCapabilitySubTLV() {
        return this.srCapabilitySubTLV;
    }

    public void setSrCapabilitySubTLV(SRCapabilityTLV srCapabilitySubTLV) {
        this.srCapabilitySubTLV = srCapabilitySubTLV;
    }
}

