/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects.tlvs;

import es.tid.pce.pcep.objects.ExplicitRouteObject;
import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.PCEPObject;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;

public class PathReservationTLV
extends PCEPTLV {
    private ExplicitRouteObject eRO;
    private long time;
    private boolean bidirectional;

    public PathReservationTLV() {
        this.TLVType = 30003;
    }

    public PathReservationTLV(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        log.debug("Encoding PathReservation TLV");
        int len = 0;
        if (this.eRO == null) {
            log.error("There are not notificationSubTLV");
            return;
        }
        this.eRO.encode();
        this.setTLVValueLength((len += this.eRO.getLength()) + 4 + 4);
        this.tlv_bytes = new byte[this.TotalTLVLength];
        int offset = 4;
        this.tlv_bytes[offset] = (byte)(this.time >>> 24);
        this.tlv_bytes[offset + 1] = (byte)(this.time >> 16 & 0xFFL);
        this.tlv_bytes[offset + 2] = (byte)(this.time >> 8 & 0xFFL);
        this.tlv_bytes[offset + 3] = (byte)(this.time & 0xFFL);
        this.tlv_bytes[(offset += 4) + 4] = (byte)(this.bidirectional ? 1 : 0);
        this.encodeHeader();
        System.arraycopy(this.eRO.getBytes(), 0, this.tlv_bytes, offset += 4, this.eRO.getLength());
    }

    public void decode() throws MalformedPCEPObjectException {
        log.debug("Decoding PathReservation TLV");
        int offset = 4;
        int k = 0;
        while (k < 4) {
            this.time = this.time << 8 | (long)(this.tlv_bytes[k + offset] & 0xFF);
            ++k;
        }
        this.bidirectional = (this.tlv_bytes[offset += 4] & 1) == 1;
        int oc = PCEPObject.getObjectClass(this.tlv_bytes, offset += 4);
        if (oc == 7) {
            log.debug("ERO Object found");
            try {
                this.eRO = new ExplicitRouteObject(this.tlv_bytes, offset);
            }
            catch (MalformedPCEPObjectException e) {
                throw new MalformedPCEPObjectException();
            }
            offset += this.eRO.getLength();
        }
    }

    public long getTime() {
        return this.time;
    }

    public ExplicitRouteObject geteRO() {
        return this.eRO;
    }

    public void setERO(ExplicitRouteObject eRO) {
        this.eRO = eRO;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public boolean isBidirectional() {
        return this.bidirectional;
    }

    public void setBidirectional(boolean bidirectional) {
        this.bidirectional = bidirectional;
    }
}

