/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects.tlvs;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public class PCE_ID_TLV
extends PCEPTLV {
    int addresType;
    Inet4Address pceId;

    public PCE_ID_TLV() {
        this.addresType = 1;
        this.TLVType = 32769;
    }

    public PCE_ID_TLV(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.setTLVValueLength(8);
        this.tlv_bytes = new byte[this.TotalTLVLength];
        this.encodeHeader();
        int offset = 4;
        this.tlv_bytes[offset] = (byte)(this.addresType >> 8 & 0xFF);
        this.tlv_bytes[offset + 1] = (byte)(this.addresType & 0xFF);
        System.arraycopy(this.pceId.getAddress(), 0, this.tlv_bytes, 8, 4);
    }

    private void decode() throws MalformedPCEPObjectException {
        if (this.TLVValueLength != 8) {
            throw new MalformedPCEPObjectException("Bad Length of PCE_ID_TLV");
        }
        int offset = 4;
        this.addresType = this.tlv_bytes[offset] << 8 & 0xFF00 | this.tlv_bytes[offset + 1] & 0xFF;
        byte[] ip = new byte[4];
        offset = 8;
        System.arraycopy(this.tlv_bytes, offset, ip, 0, 4);
        try {
            this.pceId = (Inet4Address)Inet4Address.getByAddress(ip);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            throw new MalformedPCEPObjectException("Bad IP Address");
        }
    }

    public Inet4Address getPceId() {
        return this.pceId;
    }

    public void setPceId(Inet4Address pceId) {
        this.pceId = pceId;
    }

    public int getAddresType() {
        return this.addresType;
    }

    public void setAddresType(int addresType) {
        this.addresType = addresType;
    }

    public String toString() {
        String res = "PCE ID: " + String.valueOf(this.pceId);
        return res;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.addresType;
        result = 31 * result + (this.pceId == null ? 0 : this.pceId.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PCE_ID_TLV other = (PCE_ID_TLV)obj;
        if (this.addresType != other.addresType) {
            return false;
        }
        return !(this.pceId == null ? other.pceId != null : !this.pceId.equals(other.pceId));
    }
}

