/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects.tlvs;

import es.tid.pce.pcep.objects.tlvs.OperatorAssociation;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;
import es.tid.protocol.commons.ByteHandler;
import java.util.LinkedList;

public class OpConfAssocRangeTLV
extends PCEPTLV {
    private LinkedList<OperatorAssociation> operator_associations = new LinkedList();

    public OpConfAssocRangeTLV() {
        this.setTLVType(29);
    }

    public OpConfAssocRangeTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        int num_assoc = this.operator_associations.size();
        int by = num_assoc * 8;
        this.setTLVValueLength(by);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        for (OperatorAssociation oa : this.operator_associations) {
            this.tlv_bytes[offset] = 0;
            this.tlv_bytes[offset + 1] = 0;
            this.tlv_bytes[offset + 2] = (byte)(oa.getAssocType() >> 8 & 0xFF);
            this.tlv_bytes[offset + 3] = (byte)(oa.getAssocType() & 0xFF);
            this.tlv_bytes[offset + 4] = (byte)(oa.getStartAssocID() >> 8 & 0xFF);
            this.tlv_bytes[offset + 5] = (byte)(oa.getStartAssocID() & 0xFF);
            this.tlv_bytes[offset + 6] = (byte)(oa.getRange() >> 8 & 0xFF);
            this.tlv_bytes[offset + 7] = (byte)(oa.getRange() & 0xFF);
            offset += 2;
        }
    }

    public void decode() {
        int num_assoc = this.getTLVValueLength() / 8;
        int offset = 4;
        int i = 0;
        while (i < num_assoc) {
            OperatorAssociation oa = new OperatorAssociation();
            oa.setAssocType(ByteHandler.decode2bytesInteger(this.tlv_bytes, offset += 2));
            oa.setStartAssocID(ByteHandler.decode2bytesInteger(this.tlv_bytes, offset += 2));
            oa.setRange(ByteHandler.decode2bytesInteger(this.tlv_bytes, offset += 2));
            offset += 2;
            this.operator_associations.add(oa);
            ++i;
        }
    }

    public LinkedList<OperatorAssociation> getOperator_associations() {
        return this.operator_associations;
    }

    public void setOperator_associations(LinkedList<OperatorAssociation> operator_associations) {
        this.operator_associations = operator_associations;
    }

    public String toString() {
        return "OpConfAssocRangeTLV [operator_associations=" + String.valueOf(this.operator_associations) + "]";
    }
}

