/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects.tlvs;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.tlvs.DomainIDTLV;
import java.net.Inet4Address;

public class OSPFDomainIDTLV
extends DomainIDTLV {
    Inet4Address domainId;

    public OSPFDomainIDTLV() {
        this.domainType = 3;
    }

    public OSPFDomainIDTLV(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decodeType();
        this.decode();
    }

    @Override
    public void encode() {
        this.setTLVValueLength(8);
        this.tlv_bytes = new byte[this.TotalTLVLength];
        this.encodeHeader();
        this.encodeType();
        int offset = 8;
        System.arraycopy(this.domainId.getAddress(), 0, this.tlv_bytes, offset, 4);
    }

    public void decode() throws MalformedPCEPObjectException {
        try {
            int offset = 8;
            byte[] ip = new byte[4];
            System.arraycopy(this.tlv_bytes, offset, ip, 0, 4);
            this.domainId = (Inet4Address)Inet4Address.getByAddress(ip);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MalformedPCEPObjectException("Bad DomainIDTLV");
        }
    }

    public Inet4Address getDomainId() {
        return this.domainId;
    }

    public void setDomainId(Inet4Address domainId) {
        this.domainId = domainId;
    }

    public String toString() {
        return "DomainIDTLV [domainType=" + this.domainType + ", domainId=" + String.valueOf(this.domainId) + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.domainId == null ? 0 : this.domainId.hashCode());
        result = 31 * result + this.domainType;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OSPFDomainIDTLV other = (OSPFDomainIDTLV)obj;
        if (this.domainId == null ? other.domainId != null : !this.domainId.equals(other.domainId)) {
            return false;
        }
        return this.domainType == other.domainType;
    }
}

