/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects.tlvs;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;
import java.util.LinkedList;

public class OF_LIST_TLV
extends PCEPTLV {
    private LinkedList<Integer> ofCodes;

    public OF_LIST_TLV() {
        this.TLVType = 4;
        this.ofCodes = new LinkedList();
    }

    public OF_LIST_TLV(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.ofCodes = new LinkedList();
        this.decode();
    }

    @Override
    public void encode() {
        this.setTLVValueLength(this.ofCodes.size() * 2);
        this.tlv_bytes = new byte[this.TotalTLVLength];
        this.encodeHeader();
        int offset = 4;
        int i = 0;
        while (i < this.ofCodes.size()) {
            this.tlv_bytes[offset] = (byte)(this.ofCodes.get(i) >>> 8 & 0xFF);
            this.tlv_bytes[offset + 1] = (byte)(this.ofCodes.get(i) & 0xFF);
            offset += 2;
            ++i;
        }
    }

    public void decode() throws MalformedPCEPObjectException {
        int numOfCodes = this.TLVValueLength / 2;
        int offset = 4;
        int i = 0;
        while (i < numOfCodes) {
            int ofCode = (this.tlv_bytes[offset] & 0xFF) << 8 & 0xFF00 | this.tlv_bytes[offset + 1] & 0xFF;
            this.ofCodes.add(ofCode);
            offset += 2;
            ++i;
        }
    }

    public LinkedList<Integer> getOfCodes() {
        return this.ofCodes;
    }

    public void setOfCodes(LinkedList<Integer> ofCodes) {
        this.ofCodes = ofCodes;
    }

    public String toString() {
        Object res = "OF codes: ";
        int i = 0;
        while (i < this.ofCodes.size()) {
            res = (String)res + String.valueOf(this.ofCodes.get(i)) + " ";
            ++i;
        }
        return res;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ofCodes == null ? 0 : this.ofCodes.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OF_LIST_TLV other = (OF_LIST_TLV)obj;
        return !(this.ofCodes == null ? other.ofCodes != null : !this.ofCodes.equals(other.ofCodes));
    }
}

