/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects.tlvs;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;
import es.tid.protocol.commons.ByteHandler;

public class LSPErrorCodeTLV
extends PCEPTLV {
    protected int errorCode;

    public LSPErrorCodeTLV() {
        this.TLVType = 20;
    }

    public LSPErrorCodeTLV(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        log.debug("Encoding LSPErrorCodeTLV TLV");
        int length = 4;
        this.setTLVValueLength(length);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        ByteHandler.IntToBuffer(0, offset * 8, 32, this.errorCode, this.tlv_bytes);
    }

    public void decode() throws MalformedPCEPObjectException {
        log.debug("Decoding LSPErrorCodeTLV TLV");
        int offset = 4;
        this.errorCode = ByteHandler.easyCopy(0, 31, this.tlv_bytes[offset], this.tlv_bytes[offset + 1], this.tlv_bytes[offset + 2], this.tlv_bytes[offset + 3]);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(int errorCode) {
        this.errorCode = errorCode;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.errorCode;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LSPErrorCodeTLV other = (LSPErrorCodeTLV)obj;
        return this.errorCode == other.errorCode;
    }
}

