/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects.tlvs;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;
import es.tid.protocol.commons.ByteHandler;
import java.net.Inet4Address;
import java.net.UnknownHostException;

public class IPv4LSPIdentifiersTLV
extends PCEPTLV {
    private Inet4Address tunnelSenderIPAddress;
    private int lspID;
    private int tunnelID;
    private long extendedTunnelID;
    private Inet4Address tunnelEndPointIPAddress;

    public IPv4LSPIdentifiersTLV() {
        this.TLVType = 18;
    }

    public IPv4LSPIdentifiersTLV(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        int length = 16;
        this.setTLVValueLength(length);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        System.arraycopy(this.tunnelSenderIPAddress.getAddress(), 0, this.tlv_bytes, offset, 4);
        this.tlv_bytes[offset += 4] = (byte)(this.lspID >>> 8 & 0xFF);
        this.tlv_bytes[offset + 1] = (byte)(this.lspID & 0xFF);
        this.tlv_bytes[offset + 2] = (byte)(this.tunnelID >>> 8 & 0xFF);
        this.tlv_bytes[offset + 3] = (byte)(this.tunnelID & 0xFF);
        ByteHandler.encode4bytesLong(this.extendedTunnelID, this.tlv_bytes, offset += 4);
        System.arraycopy(this.tunnelEndPointIPAddress.getAddress(), 0, this.tlv_bytes, offset += 4, 4);
    }

    public void decode() throws MalformedPCEPObjectException {
        log.debug("Decoding IPv4LSPIdentifiers TLV");
        byte[] ip = new byte[4];
        int offset = 4;
        System.arraycopy(this.tlv_bytes, offset, ip, 0, 4);
        try {
            this.tunnelSenderIPAddress = (Inet4Address)Inet4Address.getByAddress(ip);
            log.debug("Sender IP adress, tunnel: " + String.valueOf(this.tunnelSenderIPAddress));
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            throw new MalformedPCEPObjectException();
        }
        this.lspID = ByteHandler.decode2bytesInteger(this.tlv_bytes, offset += 4);
        this.tunnelID = ByteHandler.decode2bytesInteger(this.tlv_bytes, offset + 2);
        this.extendedTunnelID = ByteHandler.decode4bytesLong(this.tlv_bytes, offset += 4);
        System.arraycopy(this.tlv_bytes, offset += 4, ip, 0, 4);
        try {
            this.tunnelEndPointIPAddress = (Inet4Address)Inet4Address.getByAddress(ip);
            log.debug("Destination IP adress, tunnel: " + String.valueOf(this.tunnelEndPointIPAddress));
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            throw new MalformedPCEPObjectException();
        }
    }

    public Inet4Address getTunnelSenderIPAddress() {
        return this.tunnelSenderIPAddress;
    }

    public void setTunnelSenderIPAddress(Inet4Address tunnelSenderIPAddress) {
        this.tunnelSenderIPAddress = tunnelSenderIPAddress;
    }

    public int getLspID() {
        return this.lspID;
    }

    public void setLspID(int lspID) {
        this.lspID = lspID;
    }

    public int getTunnelID() {
        return this.tunnelID;
    }

    public void setTunnelID(int tunnelID) {
        this.tunnelID = tunnelID;
    }

    public long getExtendedTunnelID() {
        return this.extendedTunnelID;
    }

    public void setExtendedTunnelID(long extendedTunnelID) {
        this.extendedTunnelID = extendedTunnelID;
    }

    public Inet4Address getTunnelEndPointIPAddress() {
        return this.tunnelEndPointIPAddress;
    }

    public void setTunnelEndPointIPAddress(Inet4Address tunnelEndPointIPAddress) {
        this.tunnelEndPointIPAddress = tunnelEndPointIPAddress;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (int)(this.extendedTunnelID ^ this.extendedTunnelID >>> 32);
        result = 31 * result + this.lspID;
        result = 31 * result + (this.tunnelEndPointIPAddress == null ? 0 : this.tunnelEndPointIPAddress.hashCode());
        result = 31 * result + this.tunnelID;
        result = 31 * result + (this.tunnelSenderIPAddress == null ? 0 : this.tunnelSenderIPAddress.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IPv4LSPIdentifiersTLV other = (IPv4LSPIdentifiersTLV)obj;
        if (this.extendedTunnelID != other.extendedTunnelID) {
            return false;
        }
        if (this.lspID != other.lspID) {
            return false;
        }
        if (this.tunnelEndPointIPAddress == null ? other.tunnelEndPointIPAddress != null : !this.tunnelEndPointIPAddress.equals(other.tunnelEndPointIPAddress)) {
            return false;
        }
        if (this.tunnelID != other.tunnelID) {
            return false;
        }
        return !(this.tunnelSenderIPAddress == null ? other.tunnelSenderIPAddress != null : !this.tunnelSenderIPAddress.equals(other.tunnelSenderIPAddress));
    }

    public String toString() {
        return "IPv4LSPIdentifiersTLV [tunnelSenderIPAddress=" + String.valueOf(this.tunnelSenderIPAddress) + ", lspID=" + this.lspID + ", tunnelID=" + this.tunnelID + ", extendedTunnelID=" + this.extendedTunnelID + ", tunnelEndPointIPAddress=" + String.valueOf(this.tunnelEndPointIPAddress) + "]";
    }
}

