/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects.tlvs;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;
import es.tid.protocol.commons.ByteHandler;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.util.Objects;

public class ExtendedAssociationIDTLV
extends PCEPTLV {
    private long color;
    private InetAddress endpoint;

    public ExtendedAssociationIDTLV() {
        this.setTLVType(31);
    }

    public ExtendedAssociationIDTLV(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    public long getColor() {
        return this.color;
    }

    public void setColor(long color) {
        this.color = color;
    }

    public InetAddress getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(InetAddress endpoint) {
        this.endpoint = endpoint;
    }

    public String toString() {
        return "ExtendedAssociationIDTLV [color=" + this.color + ", endpoint=" + String.valueOf(this.endpoint) + "]";
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.color, this.endpoint);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ExtendedAssociationIDTLV other = (ExtendedAssociationIDTLV)obj;
        return this.color == other.color && Objects.equals(this.endpoint, other.endpoint);
    }

    @Override
    public void encode() {
        log.debug("Encoding ExtendedAssociationIDTLV TLV");
        if (this.endpoint instanceof Inet4Address) {
            this.setTLVValueLength(8);
        } else {
            this.setTLVValueLength(20);
        }
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        ByteHandler.encode4bytesLong(this.color, this.tlv_bytes, offset);
        offset += 4;
        if (this.endpoint instanceof Inet4Address) {
            System.arraycopy(this.endpoint.getAddress(), 0, this.tlv_bytes, offset, 4);
        } else {
            System.arraycopy(this.endpoint.getAddress(), 0, this.tlv_bytes, offset, 16);
        }
    }

    public void decode() throws MalformedPCEPObjectException {
        log.debug("Decoding SymbolicPathName TLV");
        int offset = 4;
        if (this.getTLVValueLength() == 0) {
            throw new MalformedPCEPObjectException();
        }
        try {
            this.color = ByteHandler.decode4bytesLong(this.tlv_bytes, offset);
            offset += 4;
            if (this.getTLVValueLength() == 8) {
                byte[] ip = new byte[4];
                System.arraycopy(this.tlv_bytes, offset, ip, 0, 4);
                this.endpoint = (Inet4Address)Inet4Address.getByAddress(ip);
                log.debug("Sended endpoint ipv4: " + String.valueOf(this.endpoint));
            } else {
                byte[] ip = new byte[16];
                System.arraycopy(this.tlv_bytes, offset, ip, 0, 16);
                this.endpoint = (Inet6Address)Inet6Address.getByAddress(ip);
                log.debug("Sended endpoint ipv6: " + String.valueOf(this.endpoint));
            }
        }
        catch (Exception e) {
            log.error("Exception occurred, Possibly TLV size is not what expected");
            throw new MalformedPCEPObjectException();
        }
    }
}

