/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects.tlvs;

import es.tid.pce.pcep.objects.tlvs.PCEPTLV;
import es.tid.protocol.commons.ByteHandler;
import java.util.Iterator;
import java.util.LinkedList;

public class ASSOCTypeListTLV
extends PCEPTLV {
    private LinkedList<Integer> association_types = new LinkedList();

    public ASSOCTypeListTLV() {
        this.setTLVType(35);
    }

    public ASSOCTypeListTLV(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        int num_assoc = this.association_types.size();
        int by = num_assoc * 2;
        this.setTLVValueLength(by);
        this.tlv_bytes = new byte[this.getTotalTLVLength()];
        this.encodeHeader();
        int offset = 4;
        Iterator i = this.association_types.iterator();
        while (i.hasNext()) {
            int valor = (Integer)i.next();
            this.tlv_bytes[offset] = (byte)(valor >> 8 & 0xFF);
            this.tlv_bytes[offset + 1] = (byte)(valor & 0xFF);
            offset += 2;
        }
        if (num_assoc % 2 > 0) {
            this.tlv_bytes[offset] = -1;
            this.tlv_bytes[offset + 1] = -1;
        }
    }

    public void decode() {
        int num_assoc = this.getTLVValueLength() / 2;
        int offset = 4;
        int i = 0;
        while (i < num_assoc) {
            int val = ByteHandler.decode2bytesInteger(this.tlv_bytes, offset);
            this.association_types.add(new Integer(val));
            offset += 2;
            ++i;
        }
    }

    public String toString() {
        Object res = "Association types: ";
        Iterator i = this.association_types.iterator();
        while (i.hasNext()) {
            int valor = (Integer)i.next();
            res = (String)res + valor + "; ";
        }
        return res;
    }

    public LinkedList<Integer> getAssociation_types() {
        return this.association_types;
    }

    public void setAssociation_types(LinkedList<Integer> association_types) {
        this.association_types = association_types;
    }
}

