/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects.subobjects;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.NAI;
import es.tid.pce.pcep.constructs.NAIIPv4Adjacency;
import es.tid.pce.pcep.constructs.NAIIPv4NodeID;
import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.protocol.commons.ByteHandler;
import es.tid.rsvp.objects.subobjects.EROSubobject;

public class SREROSubobject
extends EROSubobject {
    public static final int ST_IPv4NodeID = 1;
    public static final int ST_IPv6NodeID = 2;
    public static final int ST_IPv4Adjacency = 3;
    public static final int ST_IPv6Adjacency = 4;
    public static final int ST_UnnumberedAdjacencyIPv4NodeID = 5;
    public static final int length_IPv4NodeID = 12;
    public static final int length_IPv6NodeID = 24;
    public static final int length_IPv4Adjacency = 16;
    public static final int length_IPv6Adjacency = 40;
    public static final int length_UnnumberedAdjacencyIPv4NodeID = 24;
    protected boolean fflag;
    protected boolean sflag;
    protected boolean cflag;
    protected boolean mflag;
    protected int NT;
    protected long SID;
    protected NAI nai;

    public SREROSubobject() {
        this.fflag = true;
        this.sflag = false;
        this.cflag = false;
        this.mflag = false;
        this.loosehop = false;
        this.NT = 0;
        this.type = 36;
    }

    public SREROSubobject(byte[] bytes, int offset) {
        this.erosolength = bytes[offset + 1];
        this.subobject_bytes = new byte[this.erosolength];
        System.arraycopy(bytes, offset, this.subobject_bytes, 0, this.erosolength);
        this.decode();
    }

    @Override
    public void encode() {
        this.erosolength = 8;
        this.NT = 0;
        if (this.nai != null) {
            try {
                this.nai.encode();
                this.NT = this.nai.getNaiType();
            }
            catch (PCEPProtocolViolationException e) {
                e.printStackTrace();
            }
            this.erosolength += this.nai.getLength();
        }
        this.subobject_bytes = new byte[this.erosolength];
        this.subobject_bytes[0] = this.loosehop ? (byte)(0x80 | this.type & 0x7F) : (byte)(this.type & 0x7F);
        this.subobject_bytes[1] = (byte)this.erosolength;
        this.subobject_bytes[2] = (byte)((this.NT & 0xF) << 4);
        ByteHandler.BoolToBuffer(28, this.fflag, this.subobject_bytes);
        ByteHandler.BoolToBuffer(29, this.sflag, this.subobject_bytes);
        ByteHandler.BoolToBuffer(30, this.cflag, this.subobject_bytes);
        ByteHandler.BoolToBuffer(31, this.mflag, this.subobject_bytes);
        int offset = 4;
        if (!this.sflag) {
            ByteHandler.encode4bytesLong(this.SID, this.subobject_bytes, offset);
            offset += 4;
        }
        if (this.nai != null) {
            System.arraycopy(this.nai.getBytes(), 0, this.subobject_bytes, offset, this.nai.getLength());
        }
    }

    @Override
    public void decode() {
        this.loosehop = ByteHandler.easyCopy(0, 0, this.subobject_bytes[0]) == 1;
        this.type = this.subobject_bytes[0] & 0x7F;
        this.erosolength = this.subobject_bytes[1];
        this.NT = this.subobject_bytes[2] >> 4 & 0xF;
        this.fflag = ByteHandler.easyCopy(4, 4, this.subobject_bytes[3]) == 1;
        this.sflag = ByteHandler.easyCopy(5, 5, this.subobject_bytes[3]) == 1;
        this.cflag = ByteHandler.easyCopy(6, 6, this.subobject_bytes[3]) == 1;
        this.mflag = ByteHandler.easyCopy(7, 7, this.subobject_bytes[3]) == 1;
        int offset = 4;
        if (!this.sflag) {
            this.SID = ByteHandler.decode4bytesLong(this.subobject_bytes, offset);
            offset += 4;
        }
        if (this.erosolength > offset) {
            try {
                if (this.NT == 1) {
                    this.nai = new NAIIPv4NodeID(this.subobject_bytes, offset);
                } else if (this.NT == 3) {
                    this.nai = new NAIIPv4Adjacency(this.subobject_bytes, offset);
                }
            }
            catch (MalformedPCEPObjectException e) {
                e.printStackTrace();
            }
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("<SR subobject");
        sb.append(" SID: " + this.SID);
        sb.append(" loosehop: " + this.loosehop);
        sb.append(" type: " + this.type);
        sb.append(" length: " + this.erosolength);
        sb.append(" NT: " + this.NT);
        sb.append(" flags: |f|=" + this.fflag + " |s|=" + this.sflag + " |c|=" + this.cflag + " |m|=" + this.mflag);
        sb.append(" NAI: " + String.valueOf(this.nai));
        sb.append(">");
        return sb.toString();
    }

    public void decodeNAI() {
        switch (this.NT) {
            case 1: {
                this.decodeIPv4NodeID();
                break;
            }
            case 2: {
                this.decodeIPv6NodeID();
                break;
            }
            case 3: {
                this.decodeIPv4Adjacency();
                break;
            }
            case 4: {
                this.decodeIpv6Adjacency();
                break;
            }
            case 5: {
                this.decodeUnnumberedAdjacencyIPv4NodeID();
                break;
            }
        }
    }

    public void decodeIPv4NodeID() {
    }

    public void decodeIPv6NodeID() {
    }

    public void decodeIPv4Adjacency() {
    }

    public void decodeIpv6Adjacency() {
    }

    public void decodeUnnumberedAdjacencyIPv4NodeID() {
    }

    public boolean isfFlag() {
        return this.fflag;
    }

    public boolean iscFlag() {
        return this.cflag;
    }

    public boolean issFlag() {
        return this.sflag;
    }

    public boolean ismFlag() {
        return this.mflag;
    }

    public boolean isloosehop() {
        return this.loosehop;
    }

    @Override
    public int getType() {
        return this.type;
    }

    public long getSID() {
        return this.SID;
    }

    public void setFflag(boolean fFlag) {
        this.fflag = fFlag;
    }

    public void setCflag(boolean cFlag) {
        this.cflag = cFlag;
    }

    public void setSflag(boolean sFlag) {
        this.sflag = sFlag;
    }

    public void setMflag(boolean mFlag) {
        this.mflag = mFlag;
    }

    public void setSID(long SID) {
        this.SID = SID;
        this.sflag = false;
    }

    public int getNT() {
        return this.NT;
    }

    public void setNT(int nT) {
        this.NT = nT;
    }

    public NAI getNai() {
        return this.nai;
    }

    public void setNai(NAI nai) {
        this.nai = nai;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + this.NT;
        result = 31 * result + (int)(this.SID ^ this.SID >>> 32);
        result = 31 * result + (this.cflag ? 1231 : 1237);
        result = 31 * result + (this.fflag ? 1231 : 1237);
        result = 31 * result + (this.mflag ? 1231 : 1237);
        result = 31 * result + (this.nai == null ? 0 : this.nai.hashCode());
        result = 31 * result + (this.sflag ? 1231 : 1237);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SREROSubobject other = (SREROSubobject)obj;
        if (this.NT != other.NT) {
            return false;
        }
        if (this.SID != other.SID) {
            return false;
        }
        if (this.cflag != other.cflag) {
            return false;
        }
        if (this.fflag != other.fflag) {
            return false;
        }
        if (this.mflag != other.mflag) {
            return false;
        }
        if (this.nai == null ? other.nai != null : !this.nai.equals(other.nai)) {
            return false;
        }
        return this.sflag == other.sflag;
    }
}

