/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects.subobjects;

import es.tid.pce.pcep.objects.subobjects.XROSubobject;
import java.net.Inet6Address;
import java.net.UnknownHostException;

public class IPv6prefixXROSubobject
extends XROSubobject {
    public Inet6Address ipv6address;
    public int prefix;

    public IPv6prefixXROSubobject() {
        this.setType(2);
    }

    public IPv6prefixXROSubobject(byte[] bytes, int offset) {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.erosolength = 20;
        this.subobject_bytes = new byte[this.erosolength];
        this.encodeSoHeader();
        System.arraycopy(this.ipv6address.getAddress(), 0, this.subobject_bytes, 2, 16);
        this.subobject_bytes[18] = (byte)this.prefix;
        this.subobject_bytes[19] = (byte)this.attribute;
    }

    @Override
    public void decode() {
        byte[] ipadd = new byte[16];
        System.arraycopy(this.subobject_bytes, 2, ipadd, 0, 16);
        try {
            this.ipv6address = (Inet6Address)Inet6Address.getByAddress(ipadd);
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        this.prefix = this.subobject_bytes[18] & 0xFF;
        this.attribute = this.subobject_bytes[19] & 0xFF;
    }

    public Inet6Address getIpv6address() {
        return this.ipv6address;
    }

    public void setIpv6address(Inet6Address ipv6address) {
        this.ipv6address = ipv6address;
    }

    public int getPrefix() {
        return this.prefix;
    }

    public void setPrefix(int prefix) {
        this.prefix = prefix;
    }
}

