/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects;

import es.tid.pce.pcep.PCEPProtocolViolationException;
import es.tid.pce.pcep.constructs.SwitchEncodingType;
import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.PCEPObject;
import java.util.LinkedList;

public class SwitchLayer
extends PCEPObject {
    private LinkedList<SwitchEncodingType> switchLayers;

    public SwitchLayer() {
        this.setObjectClass(37);
        this.setOT(1);
        this.switchLayers = new LinkedList();
    }

    public SwitchLayer(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.switchLayers = new LinkedList();
        this.decode();
    }

    @Override
    public void encode() {
        int len = 4;
        int k = 0;
        while (k < this.switchLayers.size()) {
            try {
                this.switchLayers.get(k).encode();
            }
            catch (PCEPProtocolViolationException e) {
                e.printStackTrace();
            }
            len += this.switchLayers.get(k).getLength();
            ++k;
        }
        this.setObjectLength(len);
        this.object_bytes = new byte[this.ObjectLength];
        this.encode_header();
        int pos = 4;
        int k2 = 0;
        while (k2 < this.switchLayers.size()) {
            System.arraycopy(this.switchLayers.get(k2).getBytes(), 0, this.object_bytes, pos, this.switchLayers.get(k2).getLength());
            pos += this.switchLayers.get(k2).getLength();
            ++k2;
        }
    }

    @Override
    public void decode() throws MalformedPCEPObjectException {
        boolean fin = false;
        int offset = 4;
        if (this.ObjectLength == 4) {
            fin = true;
        }
        while (!fin) {
            SwitchEncodingType set;
            try {
                set = new SwitchEncodingType(this.getBytes(), offset);
                this.switchLayers.add(set);
            }
            catch (PCEPProtocolViolationException e) {
                throw new MalformedPCEPObjectException();
            }
            if ((offset += set.getLength()) < this.ObjectLength) continue;
            fin = true;
        }
    }

    public LinkedList<SwitchEncodingType> getSwitchLayers() {
        return this.switchLayers;
    }

    public void setSwitchLayers(LinkedList<SwitchEncodingType> switchLayers) {
        this.switchLayers = switchLayers;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.switchLayers == null ? 0 : this.switchLayers.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SwitchLayer other = (SwitchLayer)obj;
        return !(this.switchLayers == null ? other.switchLayers != null : !this.switchLayers.equals(other.switchLayers));
    }
}

