/*
 * Decompiled with CFR 0.152.
 */
package es.tid.pce.pcep.objects;

import es.tid.pce.pcep.objects.MalformedPCEPObjectException;
import es.tid.pce.pcep.objects.PCEPObject;
import es.tid.pce.pcep.objects.tlvs.PCEPTLV;
import es.tid.pce.pcep.objects.tlvs.PathSetupTLV;
import es.tid.pce.pcep.objects.tlvs.SymbolicPathNameTLV;
import es.tid.protocol.commons.ByteHandler;

public class SRP
extends PCEPObject {
    private boolean rFlag;
    private boolean cFlag;
    private SymbolicPathNameTLV symPathName;
    private PathSetupTLV pathSetupTLV;
    private long SRP_ID_number;

    public SRP() {
        this.setObjectClass(33);
        this.setOT(1);
    }

    public SRP(byte[] bytes, int offset) throws MalformedPCEPObjectException {
        super(bytes, offset);
        this.decode();
    }

    @Override
    public void encode() {
        this.ObjectLength = 12;
        if (this.symPathName != null) {
            this.symPathName.encode();
            this.ObjectLength += this.symPathName.getTotalTLVLength();
        }
        if (this.pathSetupTLV != null) {
            try {
                this.pathSetupTLV.encode();
                this.ObjectLength += this.pathSetupTLV.getTotalTLVLength();
            }
            catch (Exception e) {
                log.warn(e.getMessage());
            }
        }
        this.object_bytes = new byte[this.ObjectLength];
        this.encode_header();
        int offset = 4;
        ByteHandler.BoolToBuffer(7 + (offset += 3) * 8, this.rFlag, this.object_bytes);
        ByteHandler.encode4bytesLong(this.SRP_ID_number, this.object_bytes, ++offset);
        offset += 4;
        if (this.symPathName != null) {
            System.arraycopy(this.symPathName.getTlv_bytes(), 0, this.object_bytes, offset, this.symPathName.getTotalTLVLength());
            offset += this.symPathName.getTotalTLVLength();
        }
        if (this.pathSetupTLV != null) {
            System.arraycopy(this.pathSetupTLV.getTlv_bytes(), 0, this.object_bytes, offset, this.pathSetupTLV.getTotalTLVLength());
            offset += this.pathSetupTLV.getTotalTLVLength();
        }
    }

    @Override
    public void decode() throws MalformedPCEPObjectException {
        if (this.ObjectLength < 12) {
            throw new MalformedPCEPObjectException();
        }
        this.cFlag = ByteHandler.easyCopy(6, 6, this.object_bytes[7]) == 1;
        this.rFlag = ByteHandler.easyCopy(7, 7, this.object_bytes[7]) == 1;
        this.SRP_ID_number = ByteHandler.easyCopy(0, 31, this.object_bytes[8], this.object_bytes[9], this.object_bytes[10], this.object_bytes[11]);
        int offset = 12;
        boolean fin = this.ObjectLength == 12;
        while (!fin) {
            int tlvtype = PCEPTLV.getType(this.getObject_bytes(), offset);
            int tlvlength = PCEPTLV.getTotalTLVLength(this.getObject_bytes(), offset);
            switch (tlvtype) {
                case 17: {
                    this.symPathName = new SymbolicPathNameTLV(this.getObject_bytes(), offset);
                    break;
                }
                case 28: {
                    this.pathSetupTLV = new PathSetupTLV(this.getObject_bytes(), offset);
                    break;
                }
                default: {
                    log.warn("Unknown or unexpected TLV found");
                }
            }
            if ((offset += tlvlength) < this.ObjectLength) continue;
            fin = true;
        }
    }

    public long getSRP_ID_number() {
        return this.SRP_ID_number;
    }

    public void setSRP_ID_number(long sRP_ID_number) {
        this.SRP_ID_number = sRP_ID_number;
    }

    public SymbolicPathNameTLV getSymPathName() {
        return this.symPathName;
    }

    public void setSymPathName(SymbolicPathNameTLV symPathName) {
        this.symPathName = symPathName;
    }

    public boolean isRFlag() {
        return this.rFlag;
    }

    public void setRFlag(boolean rFlag) {
        this.rFlag = rFlag;
    }

    public PathSetupTLV getPathSetupTLV() {
        return this.pathSetupTLV;
    }

    public void setPathSetupTLV(PathSetupTLV pathSetupTLV) {
        this.pathSetupTLV = pathSetupTLV;
    }

    public boolean isCFlag() {
        return this.cFlag;
    }

    public void setCFlag(boolean cFlag) {
        this.cFlag = cFlag;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(100);
        sb.append("<SRP id = ");
        sb.append(this.SRP_ID_number);
        if (this.symPathName != null) {
            sb.append(this.symPathName.toString());
        }
        sb.append(">");
        return sb.toString();
    }
}

